<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method canRefundMoneyByParams(array $params)
 * @method applyByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取可退款金额
     *
     * @param  int $account_id 关联账户id [ require true ]
     * @param  string $type 退款类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canRefundMoney (int $account_id, string $type) {
        return self::getClass()->canRefundMoney([
            "account_id" => $account_id,
            "type" => $type,
        ]);
    }

    /**
     * 申请退款
     *
     * @support  int $account_id 关联资金账户id [ require true ]
     * @support  float $money 退款金额 [ require true ]
     * @support  string $type 退款类型 [ require true ]
     * @support  string $account_type 收款账号类型 [ require true ]
     * @support  string $name 用户名/收款单位名称 require false
     * @support  string $account 收款账号 require false
     * @support  string $bank_name 开户行名称 require false
     * @support  string $note 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function apply () {
        return self::getClass()->apply();
    }

    /**
     * 退款详情
     *
     * @support  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 退款列表
     *
     * @support  string $type 类型 require false
     * @support  string $enterprise_name 企业名称 require false
     * @support  string $status 退款状态 require false
     * @support  int $account_id 资金账户id require false
     * @support  int $input_staff_id 申请人 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}