<?php
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getStoreByParams(array $params)
 * @method getAllPriceAreaByParams(array $params)
 * @method getProductJxjyPriceByParams(array $params)
 * @method getBanStoreListByParams(array $params)
 * @method getShortUrlByParams(array $params)
 * @method sendMsgByParams(array $params)
 * @method getAllProvinceByParams(array $params)
 * @method getCityByParams(array $params)
 * @method getEnumByParams(array $params)
 * @method getProductTreeByModulesByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取Host地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 获取所有门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStore () {
        return self::getClass()->getStore();
    }

    /**
     * 根据价格区id获取所有门店
     *
     * @support  string $module 品牌 require false
     * @support  array $ids 价格区ids require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllPriceArea () {
        return self::getClass()->getAllPriceArea();
    }

    /**
     * 根据产品id获取加修价格
     *
     * @param  int $productId 产品id [ require true ]
     * @param  int $peopleCount 人数 [ require true ]
     * @param  array $storeLimit 门店限制信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductJxjyPrice (int $productId, int $peopleCount, array $storeLimit) {
        return self::getClass()->getProductJxjyPrice([
            "productId" => $productId,
            "peopleCount" => $peopleCount,
            "storeLimit" => $storeLimit,
        ]);
    }

    /**
     * 获取禁止售卖指定产品的门店列表
     *
     * @param  array $productIds 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBanStoreList (array $productIds) {
        return self::getClass()->getBanStoreList([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 获取短链接
     *
     * @param  string $url 链接前缀 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShortUrl (string $url) {
        return self::getClass()->getShortUrl([
            "url" => $url,
        ]);
    }

    /**
     * 发送券码订单通知
     *
     * @param  string $template 模版id [ require true ]
     * @param  string $sendType 发送类型 [ require true ]
     * @param  array $sendArr 待发名单 [ require true ]
     * @param  array $sendContent 发送内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMsg (string $template, string $sendType, array $sendArr, array $sendContent) {
        return self::getClass()->sendMsg([
            "template" => $template,
            "sendType" => $sendType,
            "sendArr" => $sendArr,
            "sendContent" => $sendContent,
        ]);
    }

    /**
     * 获取所有省份
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProvince () {
        return self::getClass()->getAllProvince();
    }

    /**
     * 获取指定省份下的城市
     *
     * @param  int $province_id 上级省ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCity (int $province_id) {
        return self::getClass()->getCity([
            "province_id" => $province_id,
        ]);
    }

    /**
     * 获取enum
     *
     * @param  string $enum_name enum的名称 [ require true ]
     * @param  string $field_name field的名称 [ require true ]
     * @param  string $type 结果展示的方式tree/map/list [ require true ]
     * @param  string $prefix 枚举前缀 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEnum (string $enum_name, string $field_name, string $type, string $prefix = '') {
        return self::getClass()->getEnum([
            "enum_name" => $enum_name,
            "field_name" => $field_name,
            "type" => $type,
            "prefix" => $prefix,
        ]);
    }

    /**
     * 根据MODULE获取类目/产品树
     *
     * @support  array $module 所属模块组 require false
     * @support  string $status 产品状态（默认上架） require false
     * @support  bool $c_hidden 是否包含预约端隐藏 require false
     * @support  int $show_level 起始类目等级 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductTreeByModules () {
        return self::getClass()->getProductTreeByModules();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}