<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method getStoreListByParams(array $params)
 * @method getProductsByStoreByParams(array $params)
 * @method getProductDetailByParams(array $params)
 * @method payOrderByParams(array $params)
 * @method detailByParams(array $params)
 * @method getPhotoOrderByParams(array $params)
 * @method batchUpdatePhotoOrderStoreByParams(array $params)
 * @method getRejectPhotoOrderListByOrderIdByParams(array $params)
 * @method closeByParams(array $params)
 * @method cancelByParams(array $params)
 * @method unextractGroupOrderCountByParams(array $params)
 */
class OrderShoot {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄订单列表
     *
     * @support  string $order_status 订单状态 require false
     * @support  string $payment_status 付款类型 require false
     * @support  string $contract_no 订单的合同编号 require false
     * @support  string $order_no 订单编号 require false
     * @support  string $enterprise_name 企业名称 require false
     * @support  int $enterprise_id 企业id require false
     * @support  string $link 联系人 require false
     * @support  string $customer_phone 联系电话 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 新增拍摄订单
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer require false
     * @support  array $purchase_info 购买内容 require false
     * @support  string $remark 订单备注 require false
     * @support  string $advanced 是否分期 require false
     * @support  float $origin_price 订单原价 [ require true ]
     * @support  float $real_pay 订单实际支付 [ require true ]
     * @support  float $discount 折扣 [ require true ]
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑拍摄订单
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer require false
     * @support  array $purchase_info 购买内容 require false
     * @support  string $remark 订单备注 require false
     * @support  string $advanced 是否分期 require false
     * @support  float $origin_price 订单原价 [ require true ]
     * @support  float $real_pay 订单实际支付 [ require true ]
     * @support  float $discount 折扣 [ require true ]
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit();
    }

    /**
     * 获取门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreList () {
        return self::getClass()->getStoreList();
    }

    /**
     * 获取门店所有产品
     *
     * @support  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsByStore () {
        return self::getClass()->getProductsByStore();
    }

    /**
     * 获取产品详情
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDetail () {
        return self::getClass()->getProductDetail();
    }

    /**
     * 确认支付
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $account_id 资金账户id [ require true ]
     * @support  float $pay_order_money 实际支付金额 [ require true ]
     * @support  float $credit_order_money 授信额度抵扣金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrder () {
        return self::getClass()->payOrder();
    }

    /**
     * 订单详情
     *
     * @support  int $order_id 订单id require false
     * @support  int $id 订单合同id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取关联拍摄订单列表
     *
     * @support  int $group_order_id 团购订单ID require false
     * @support  string $user_phone 手机号 require false
     * @support  string $user_name 姓名 require false
     * @support  string $order_no 订单号 require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoOrder () {
        return self::getClass()->getPhotoOrder();
    }

    /**
     * 修改拍摄门店
     *
     * @support  array $data 重新指定的拍摄门店数据集（如：[id=&gt;审批详情ID_1,store_id =&gt; 重新指定的门店ID_1,store_name =&gt; 重新指定的门店名称_1]） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdatePhotoOrderStore () {
        return self::getClass()->batchUpdatePhotoOrderStore();
    }

    /**
     * 获取门店驳回、取消订单列表
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRejectPhotoOrderListByOrderId () {
        return self::getClass()->getRejectPhotoOrderListByOrderId();
    }

    /**
     * 关闭订单
     *
     * @support  int $id 订单合同id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * 取消拍摄订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $reason 取消原因 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 获取未提取海马体订单的团购单数量
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unextractGroupOrderCount () {
        return self::getClass()->unextractGroupOrderCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\OrderShoot');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\OrderShoot');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}