<?php
namespace Mainto\Bridge\Enums\Business;

class PaymentRecordEnum {
    const AUDIT_STATUS_WAIT_AUDIT = 'wait_audit';
    const AUDIT_STATUS_WAIT_CANCEL = 'cancel';
    const AUDIT_STATUS_REJECTED = 'rejected';
    const AUDIT_STATUS_PASSED = 'passed';
    const AUDIT_STATUS_MAP = ['wait_audit' => '待审核','cancel' => '取消审核','rejected' => '未通过','passed' => '已通过'];
    const STATUS_WAIT_PAY = 'wait_pay';
    const STATUS_FINISHED = 'finished';
    const STATUS_CANCEL = 'cancel';
    const STATUS_MAP = ['wait_pay' => '等待支付','finished' => '已通过','cancel' => '取消支付'];
    const ALIPAY = 'alipay';
    const WECHAT = 'wechat';
    const ICBC_WECHAT = 'icbc_wechat';
    const OFFLINE_ALIPAY = 'offline_alipay';
    const OFFLINE_WECHAT = 'offline_wechat';
    const CASH = 'cash';
    const GROUP_BUY = 'group_buy';
    const MEITUAN_DIANPING = 'meituan_dianping';
    const NUOMI = 'nuomi';
    const POS = 'pos';
    const GIFT_CARD = 'gift_card';
    const ENTERPRISE = 'enterprise';
    const MARKET_CARD = 'market_card';
    const PAYMAX_WECHAT = 'paymax_wechat';
    const PAYMAX_ALIPAY = 'paymax_alipay';
    const OFFLINE_PAYMAX_ALIPAY = 'offline_paymax_alipay';
    const OFFLINE_PAYMAX_WECHAT = 'offline_paymax_wechat';
    const OFFLINE_PAYMAX_BANKCARD = 'offline_paymax_bankcard';
    const PAY_TYPE_MAP = ['alipay' => '线上支付宝','wechat' => '线上微信','icbc_wechat' => 'icbc微信','offline_alipay' => '线下支付宝','offline_wechat' => '线下微信','cash' => '现金支付','group_buy' => '团购','meituan_dianping' => '美团和点评','nuomi' => '糯米','pos' => 'POS机','gift_card' => '礼品卡','enterprise' => '企业对公打款','market_card' => '商场卡','paymax_wechat' => '拉卡拉微信','paymax_alipay' => '拉卡拉支付宝','offline_paymax_alipay' => '拉卡拉线下支付宝','offline_paymax_wechat' => '拉卡拉线下微信','offline_paymax_bankcard' => '拉卡拉线下银行卡'];
    const PAYMENT_REASON_NORMAL_PAY = 'normal_pay';
    const PAYMENT_REASON_STAFF_PAY = 'staff_pay';
    const PAYMENT_REASON_DIFF_PAY = 'diff_pay';
    const APPEND_PAYMENT_REASON_MAP = [0 => 'staff_pay',1 => 'diff_pay'];
    const PAYMENT_TYPE_TOTAL_PAY = 'total_pay';
    const PAYMENT_TYPE_STAFF_PAY = 'staff_pay';
    const PAYMENT_TYPE_PAY_MAP = [0 => 'total_pay',1 => 'staff_pay'];
}