<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method enterpriseGroupListByParams(array $params)
 * @method createEnterpriseGroupByParams(array $params)
 * @method enterpriseGroupDetailByParams(array $params)
 * @method editEnterpriseGroupByParams(array $params)
 * @method addEnterpriseByParams(array $params)
 * @method editEnterpriseByParams(array $params)
 * @method getEnterpriseListByParams(array $params)
 * @method transferEnterpriseByParams(array $params)
 * @method getEnterpriseTransferLogByParams(array $params)
 * @method deleteEnterpriseByParams(array $params)
 * @method getEnterpriseByParams(array $params)
 * @method getEnterpriseByNameByParams(array $params)
 * @method getEnterpriseInfoByParams(array $params)
 * @method checkEnterpriseOrderStatusByParams(array $params)
 */
class Enterprise {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取企业组列表
     * @deprecated
     *
     * @param  string $link 客户姓名 [ require true ]
     * @param  string $enterprise_group_name 企业名称 [ require true ]
     * @param  string $customer_phone 客户手机号 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function enterpriseGroupList (string $enterprise_group_name = '', string $link = '', string $customer_phone = '', int $page = 1, int $page_size = 10) {
        return self::getClass()->enterpriseGroupList([
            "enterprise_group_name" => $enterprise_group_name,
            "link" => $link,
            "customer_phone" => $customer_phone,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 创建企业组
     * @deprecated
     *
     * @param  string $enterprise_group_name 企业组名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createEnterpriseGroup (string $enterprise_group_name) {
        return self::getClass()->createEnterpriseGroup([
            "enterprise_group_name" => $enterprise_group_name,
        ]);
    }

    /**
     * 查看企业组详情
     * @deprecated
     *
     * @param  int $enterprise_group_id 企业组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function enterpriseGroupDetail (int $enterprise_group_id) {
        return self::getClass()->enterpriseGroupDetail([
            "enterprise_group_id" => $enterprise_group_id,
        ]);
    }

    /**
     * 编辑企业组
     * @deprecated
     *
     * @param  string $enterprise_group_name 企业组名称 [ require true ]
     * @param  int $enterprise_group_id 企业组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editEnterpriseGroup (string $enterprise_group_name, int $enterprise_group_id) {
        return self::getClass()->editEnterpriseGroup([
            "enterprise_group_name" => $enterprise_group_name,
            "enterprise_group_id" => $enterprise_group_id,
        ]);
    }

    /**
     * 添加企业
     *
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $type 企业类型 [ require true ]
     * @support  string $title 抬头 
     * @support  string $tax_num 税号 
     * @support  string $enterprise_address 企业地址 
     * @support  string $enterprise_phone 企业电话 
     * @support  string $bank 开户行 
     * @support  string $bank_account 开户行账号 
     * @support  string $from 来源 
     * @support  string $trade 行业 
     * @support  string $area 地区 
     * @support  string $social_credit_code 社会信用编码 
     * @support  string $note 备注 
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addEnterprise () {
        return self::getClass()->addEnterprise();
    }

    /**
     * 编辑企业
     *
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  string $enterprise_name 企业名称 
     * @support  string $type 企业名称 
     * @support  string $title 抬头 
     * @support  string $tax_num 税号 
     * @support  string $enterprise_address 企业地址 
     * @support  string $enterprise_phone 企业电话 
     * @support  string $bank 开户行 
     * @support  string $bank_account 开户行账号 
     * @support  string $from 来源 
     * @support  string $trade 行业 
     * @support  string $area 地区 
     * @support  string $social_credit_code 社会信用编码 
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editEnterprise () {
        return self::getClass()->editEnterprise();
    }

    /**
     * 企业列表
     *
     * @support  string $enterprise_name 企业名称 
     * @support  string $from 来源 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEnterpriseList () {
        return self::getClass()->getEnterpriseList();
    }

    /**
     * 转移客户
     *
     * @support  array $enterprise_ids 一批企业 
     * @support  int $receive_staff 接收人 
     * @support  bool $all_transfer 是否全部转移 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function transferEnterprise () {
        return self::getClass()->transferEnterprise();
    }

    /**
     * 企业归属记录
     *
     * @support  int $enterprise_id 企业id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEnterpriseTransferLog () {
        return self::getClass()->getEnterpriseTransferLog();
    }

    /**
     * 删除企业
     *
     * @param  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function deleteEnterprise (int $enterprise_id) {
        return self::getClass()->deleteEnterprise([
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 根据名称或者企业组id获取企业
     *
     * @param  string $enterprise_name 企业名称(模糊匹配) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterprise (string $enterprise_name = '') {
        return self::getClass()->getEnterprise([
            "enterprise_name" => $enterprise_name,
        ]);
    }

    /**
     * 根据名称或者企业id获取企业
     *
     * @param  string $enterprise_name 企业名称(精准匹配) [ require true ]
     * @param  int $enterprise_id 企业id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseByName (string $enterprise_name = '', int $enterprise_id = 0) {
        return self::getClass()->getEnterpriseByName([
            "enterprise_name" => $enterprise_name,
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 根据企业id获取企业信息
     *
     * @param  int $enterprise_id 企业id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterpriseInfo (int $enterprise_id) {
        return self::getClass()->getEnterpriseInfo([
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 检查某个企业下所有进行中的拍摄订单团购单拍摄状态
     *
     * @support  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkEnterpriseOrderStatus () {
        return self::getClass()->checkEnterpriseOrderStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Enterprise');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Enterprise');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}