<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method contractListByParams(array $params)
 * @method yearContractListByParams(array $params)
 * @method bindContractListByParams(array $params)
 * @method bindYearContractListByParams(array $params)
 * @method createContractByParams(array $params)
 * @method createYearContractByParams(array $params)
 * @method contractDetailByParams(array $params)
 * @method yearContractDetailByParams(array $params)
 * @method orderListByParams(array $params)
 * @method editContractByParams(array $params)
 * @method deleteContractByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method editOrderByParams(array $params)
 * @method payOrderByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method uploadFinalFileByParams(array $params)
 * @method getBindOrdersByParams(array $params)
 */
class Contract {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询业务合同
     *
     * @support  string $start_at 开始日期 require false
     * @support  string $end_at 结束日期 require false
     * @support  string $enterprise_name 企业名称 require false
     * @support  string $customer_phone 客户手机号 require false
     * @param  int $creator_id 创建人 [ require true ]
     * @support  bool $is_final_contract 是否为盖印合同 require false
     * @support  string $contract_type 合同类型，special_contract/normal_contract require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @support  string $contract_no 合同号 require false
     * @param  string $desc_sort_column 以什么字段倒序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function contractList (int $creator_id = 0, int $page = 1, int $page_size = 10, string $desc_sort_column = 'created_at') {
        return self::getClass()->contractList([
            "creator_id" => $creator_id,
            "page" => $page,
            "page_size" => $page_size,
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 查询框架合同
     *
     * @support  string $start_at 生效开始日期 require false
     * @support  string $end_at 生效结束日期 require false
     * @support  string $create_start_at 创建开始日期 require false
     * @support  string $create_end_at 创建结束日期 require false
     * @support  string $enterprise_name 企业名称 require false
     * @support  string $customer_phone 客户手机号 require false
     * @param  int $creator_id 创建人 [ require true ]
     * @support  bool $is_final_contract 是否为盖印合同 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @support  string $contract_no 合同号 require false
     * @param  string $desc_sort_column 以什么字段倒序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function yearContractList (int $creator_id = 0, int $page = 1, int $page_size = 10, string $desc_sort_column = 'created_at') {
        return self::getClass()->yearContractList([
            "creator_id" => $creator_id,
            "page" => $page,
            "page_size" => $page_size,
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 获取绑定业务合同
     *
     * @support  string $enterprise_name 企业名称 require false
     * @support  bool $is_final_contract 是否为盖印合同 require false
     * @support  string $contract_no 合同号 require false
     * @param  string $desc_sort_column 以什么字段倒序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindContractList (string $desc_sort_column = 'created_at') {
        return self::getClass()->bindContractList([
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 获取绑定框架合同
     *
     * @support  string $enterprise_name 企业名称 require false
     * @support  bool $is_final_contract 是否为盖印合同 require false
     * @support  string $contract_no 合同号 require false
     * @param  string $desc_sort_column 以什么字段倒序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindYearContractList (string $desc_sort_column = 'created_at') {
        return self::getClass()->bindYearContractList([
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 创建业务合同
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  float $contract_money 合同金额 [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer require false
     * @support  string $contract_file_path 合同地址 [ require true ]
     * @support  string $contract_file_name 合同名称 [ require true ]
     * @support  string $remark 合同备注 require false
     * @support  array $discount_info 折扣 require false
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createContract () {
        return self::getClass()->createContract();
    }

    /**
     * 创建框架合同
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer require false
     * @support  string $contract_file_path 合同地址 [ require true ]
     * @support  string $contract_file_name 合同名称 [ require true ]
     * @support  string $start_at 框架生效时间 require false
     * @support  string $end_at 框架结束时间 require false
     * @support  string $contract_file_name 合同名称 [ require true ]
     * @support  string $remark 合同备注 require false
     * @support  array $discount_info 折扣 require false
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createYearContract () {
        return self::getClass()->createYearContract();
    }

    /**
     * 业务合同详情
     *
     * @param  int $id 合同id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function contractDetail (int $id) {
        return self::getClass()->contractDetail([
            "id" => $id,
        ]);
    }

    /**
     * 框架合同详情
     *
     * @param  int $id 合同id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function yearContractDetail (int $id) {
        return self::getClass()->yearContractDetail([
            "id" => $id,
        ]);
    }

    /**
     * 合同订单列表
     *
     * @param  int $id 合同id [ require true ]
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 每页行数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderList (int $id, int $page = 1, int $page_size = 20) {
        return self::getClass()->orderList([
            "id" => $id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 修改合同
     *
     * @param  int $id 合同id [ require true ]
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  float $contract_money 合同金额 require false
     * @support  string $customer_type 顾客类型，old_customer/new_customer require false
     * @support  string $contract_file_path 合同地址 [ require true ]
     * @support  string $contract_file_name 合同名称 [ require true ]
     * @support  string $remark 合同备注 require false
     * @support  array $discount_info 折扣 require false
     * @param  string $contract_type 合同类型 [ require true ]
     * @support  array $extend 扩展信息 require false
     * @support  string $start_at 框架生效时间 require false
     * @support  string $end_at 框架失效时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editContract (int $id, string $contract_type) {
        return self::getClass()->editContract([
            "id" => $id,
            "contract_type" => $contract_type,
        ]);
    }

    /**
     * 删除合同
     *
     * @param  int $id 合同id [ require true ]
     * @param  string $contract_type 合同类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteContract (int $id, string $contract_type) {
        return self::getClass()->deleteContract([
            "id" => $id,
            "contract_type" => $contract_type,
        ]);
    }

    /**
     * 合同内创建订单
     *
     * @support  string $order_type 订单类型 require false
     * @support  string $brand 品牌 require false
     * @support  array $purchase_info 购买内容 require false
     * @support  string $consume_method 核销方式 require false
     * @support  int $white_list_id 白名单id require false
     * @support  string $remark 订单备注 require false
     * @support  float $origin_price 订单原价 [ require true ]
     * @support  float $real_pay 订单实际支付 [ require true ]
     * @support  int $contract_id 合同id [ require true ]
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 合同内删除订单
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder (int $id) {
        return self::getClass()->deleteOrder([
            "id" => $id,
        ]);
    }

    /**
     * 合同内编辑订单
     *
     * @param  int $id 合同id [ require true ]
     * @support  string $order_type 订单类型 require false
     * @support  string $brand 品牌 require false
     * @support  array $purchase_info 购买内容 require false
     * @support  string $consume_method 核销方式 require false
     * @support  int $white_list_id 白名单id require false
     * @support  string $remark 订单备注 require false
     * @support  float $origin_price 订单原价 [ require true ]
     * @support  float $real_pay 订单实际支付金额 [ require true ]
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editOrder (int $id) {
        return self::getClass()->editOrder([
            "id" => $id,
        ]);
    }

    /**
     * 合同内订单确认支付
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $account_id 资金账户id [ require true ]
     * @support  float $pay_order_money 实际支付金额 [ require true ]
     * @support  float $credit_order_money 授信额度抵扣金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrder () {
        return self::getClass()->payOrder();
    }

    /**
     * 合同内订单详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderDetail (int $order_id) {
        return self::getClass()->orderDetail([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 上传盖印合同
     *
     * @param  int $contract_id 合同id [ require true ]
     * @param  string $final_file_path 盖印合同文件地址 [ require true ]
     * @param  string $final_file_name 盖印合同文件名 [ require true ]
     * @param  string $contract_type 合同类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadFinalFile (int $contract_id, string $contract_type, string $final_file_path, string $final_file_name) {
        return self::getClass()->uploadFinalFile([
            "contract_id" => $contract_id,
            "contract_type" => $contract_type,
            "final_file_path" => $final_file_path,
            "final_file_name" => $final_file_name,
        ]);
    }

    /**
     * 获取框架合同绑定订单列表
     *
     * @param  int $contract_id 合同id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBindOrders (int $contract_id, int $page = 1, int $page_size = 20) {
        return self::getClass()->getBindOrders([
            "contract_id" => $contract_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Contract');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Contract');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}