<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method payOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method editOrderByParams(array $params)
 * @method payOrderFinalByParams(array $params)
 * @method getPurchaseInfoByParams(array $params)
 * @method codeStatusCountByParams(array $params)
 * @method cancelByParams(array $params)
 * @method abolishByLogIdByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询订单
     *
     * @support  string $order_status 订单状态 require false
     * @support  string $payment_status 付款类型 require false
     * @support  string $contract_no 订单的合同编号 require false
     * @support  string $order_no 订单编号 require false
     * @support  string $customer_phone 联系电话 require false
     * @support  string $link 联系人 require false
     * @support  string $enterprise_name 企业名称 require false
     * @support  int $enterprise_id 企业id require false
     * @support  int $creator_id 创建人id require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderList (int $page = 1, int $page_size = 10) {
        return self::getClass()->orderList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 订单详情
     *
     * @support  int $order_id 订单id require false
     * @support  int $id 订单合同id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * 新增订单
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer require false
     * @support  string $order_type 订单类型 require false
     * @support  string $brand 品牌 require false
     * @support  array $purchase_info 购买内容 require false
     * @support  string $consume_method 核销方式 require false
     * @support  int $white_list_id 白名单id require false
     * @support  string $remark 订单备注 require false
     * @support  string $advanced 是否分期 require false
     * @support  float $origin_price 订单原价 [ require true ]
     * @support  float $real_pay 订单实际支付 [ require true ]
     * @support  float $discount 折扣 [ require true ]
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 确认支付
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $account_id 资金账户id [ require true ]
     * @support  float $pay_order_money 实际支付金额 [ require true ]
     * @support  float $credit_order_money 授信额度抵扣金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrder () {
        return self::getClass()->payOrder();
    }

    /**
     * 删除订单
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder () {
        return self::getClass()->deleteOrder();
    }

    /**
     * 编辑订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [ require true ]
     * @support  int $enterprise_id 企业id [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer require false
     * @support  string $order_type 订单类型 require false
     * @support  string $brand 品牌 require false
     * @support  array $purchase_info 购买内容 require false
     * @support  string $consume_method 核销方式 require false
     * @support  int $white_list_id 白名单id require false
     * @support  string $remark 订单备注 require false
     * @support  string $advanced 是否分期 require false
     * @support  float $origin_price 订单原价 [ require true ]
     * @support  float $real_pay 订单实际支付 [ require true ]
     * @support  float $discount 折扣 [ require true ]
     * @support  array $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editOrder () {
        return self::getClass()->editOrder();
    }

    /**
     * 支付尾款
     * @deprecated
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_at 付款日期 require false
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  float $final_pay_money 尾款 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $fluent_num 流水号 require false
     * @support  array $change_info 购买物变更信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrderFinal () {
        return self::getClass()->payOrderFinal();
    }

    /**
     * 获取订单购买详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPurchaseInfo (int $order_id) {
        return self::getClass()->getPurchaseInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 券码订单中已提取券码状态数量
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function codeStatusCount () {
        return self::getClass()->codeStatusCount();
    }

    /**
     * 取消券码订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $reason 取消原因 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 根据创建记录作废券码
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $create_log_id 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolishByLogId (int $id, string $type, int $create_log_id) {
        return self::getClass()->abolishByLogId([
            "id" => $id,
            "type" => $type,
            "create_log_id" => $create_log_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}