<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method abandonClueByParams(array $params)
 * @method receiveClueByParams(array $params)
 * @method transferClueByParams(array $params)
 */
class Clue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 放弃线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abandonClue () {
        return self::getClass()->abandonClue();
    }

    /**
     * 领取线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveClue () {
        return self::getClass()->receiveClue();
    }

    /**
     * 转移线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  int $receive_staff 转移的员工id [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function transferClue () {
        return self::getClass()->transferClue();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Clue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Clue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}