<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createClueByParams(array $params)
 * @method editClueByParams(array $params)
 * @method clueDetailByParams(array $params)
 * @method clueListByParams(array $params)
 * @method abandonClueByParams(array $params)
 * @method receiveClueByParams(array $params)
 * @method transferClueByParams(array $params)
 */
class Clue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建线索
     *
     * @support  string $title 线索名称 [ require true ]
     * @support  string $from 线索来源 [ require true ]
     * @support  string $contact_name 联系人姓名 [ require true ]
     * @support  string $contact_gender 性别 
     * @support  string $contact_postcard 名片 
     * @support  string $contact_phone 联系人电话 [ require true ]
     * @support  int $photograph_area 城市id [ require true ]
     * @support  int $belong_staff 归属人工号 [ require true ]
     * @support  string $remark 备注 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createClue () {
        return self::getClass()->createClue();
    }

    /**
     * 编辑线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  string $title 线索名称 [ require true ]
     * @support  string $from 线索来源 [ require true ]
     * @support  string $contact_name 联系人姓名 [ require true ]
     * @support  string $contact_gender 性别 
     * @support  string $contact_postcard 名片 
     * @support  string $contact_phone 联系人电话 [ require true ]
     * @support  int $photograph_area 城市id [ require true ]
     * @support  string $remark 备注 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editClue () {
        return self::getClass()->editClue();
    }

    /**
     * 线索详情
     *
     * @param  int $clue_id 线索id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clueDetail (int $clue_id) {
        return self::getClass()->clueDetail([
            "clue_id" => $clue_id,
        ]);
    }

    /**
     * 线索列表
     *
     * @support  string $title 线索名称 
     * @support  string $from 线索来源 
     * @support  int $photograph_area 拍摄城市id 
     * @support  int $belong_staff 归属人 [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  string $desc_sort_column 以什么字段倒序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clueList (int $page = 1, int $page_size = 10, string $desc_sort_column = 'created_at') {
        return self::getClass()->clueList([
            "page" => $page,
            "page_size" => $page_size,
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 放弃线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abandonClue () {
        return self::getClass()->abandonClue();
    }

    /**
     * 领取线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveClue () {
        return self::getClass()->receiveClue();
    }

    /**
     * 转移线索
     *
     * @support  int $clue_id 线索id [ require true ]
     * @support  int $receive_staff 转移的员工id [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function transferClue () {
        return self::getClass()->transferClue();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Clue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Clue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}