<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method flowListByParams(array $params)
 */
class Account {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建资金账户
     *
     * @param  int $enterprise_id 企业id [ require true ]
     * @param  string $account_type 账户类型 [ require true ]
     * @param  string $account_name 账户名称 [ require true ]
     * @param  string $social_credit_code 社会信用编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $enterprise_id, string $account_type, string $account_name, string $social_credit_code = NULL) {
        return self::getClass()->create([
            "enterprise_id" => $enterprise_id,
            "account_type" => $account_type,
            "account_name" => $account_name,
            "social_credit_code" => $social_credit_code,
        ]);
    }

    /**
     * 编辑资金账户
     *
     * @param  int $account_id 企业id [ require true ]
     * @param  string $account_type 账户类型 [ require true ]
     * @param  string $account_name 账户名称 [ require true ]
     * @param  string $social_credit_code 社会信用编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $account_id, string $account_type = '', string $account_name = '', string $social_credit_code = NULL) {
        return self::getClass()->update([
            "account_id" => $account_id,
            "account_type" => $account_type,
            "account_name" => $account_name,
            "social_credit_code" => $social_credit_code,
        ]);
    }

    /**
     * 资金账户列表
     *
     * @param  int $enterprise_id 企业id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $enterprise_id, int $page = 1, int $page_size = 15) {
        return self::getClass()->list([
            "enterprise_id" => $enterprise_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 资金流水列表
     *
     * @param  int $enterprise_id 企业id [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function flowList (int $enterprise_id, int $page = 1, int $page_size = 15) {
        return self::getClass()->flowList([
            "enterprise_id" => $enterprise_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Account');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Account');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}