<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addAppendPaymentByParams(array $params)
 * @method editAppendPaymentByParams(array $params)
 * @method deleteAppendPaymentRecordByParams(array $params)
 * @method appendPaymentRecordListByParams(array $params)
 * @method createPaymentRecordByParams(array $params)
 * @method deletePaymentRecordByParams(array $params)
 * @method paymentRecordListByParams(array $params)
 */
class PaymentRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入追加付款/version3.0.0起不再支持追加付款
     * @deprecated
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  float $pay_money 付款金额 [Original type double] [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $pay_reason 支付原因 [ require true ]
     * @support  string $fluent_num 流水号 
     * @support  string $remark 付款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAppendPayment () {
        return self::getClass()->addAppendPayment();
    }

    /**
     * 编辑追加付款/version3.0.0起不再支持追加付款
     * @deprecated
     *
     * @support  int $id 付款记录id [Original type uint] [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  float $pay_money 付款金额 [Original type double] [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $pay_reason 支付原因 [ require true ]
     * @support  string $fluent_num 流水号 
     * @support  string $remark 付款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editAppendPayment () {
        return self::getClass()->editAppendPayment();
    }

    /**
     * 删除追加付款/version3.0.0起不再支持追加付款
     * @deprecated
     *
     * @support  int $id 付款记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteAppendPaymentRecord () {
        return self::getClass()->deleteAppendPaymentRecord();
    }

    /**
     * 获取追加付款记录列表(仅限于单订单合同)
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页行数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function appendPaymentRecordList (int $id, int $page = 1, int $page_size = 20) {
        return self::getClass()->appendPaymentRecordList([
            "id" => $id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 新增付款
     *
     * @support  string $payment_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $fluent_num 流水号 [ require true ]
     * @support  string $remark 付款备注 
     * @support  int $account_id 资金账户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPaymentRecord () {
        return self::getClass()->createPaymentRecord();
    }

    /**
     * 删除付款记录
     *
     * @support  int $id 付款记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePaymentRecord () {
        return self::getClass()->deletePaymentRecord();
    }

    /**
     * 获取付款记录列表
     *
     * @param  int $account_id 资金池账户id [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页行数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paymentRecordList (int $account_id, int $page = 1, int $page_size = 20) {
        return self::getClass()->paymentRecordList([
            "account_id" => $account_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\PaymentRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\PaymentRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}