<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method canRefundMoneyByParams(array $params)
 * @method applyByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取可退款金额
     *
     * @param  int $order_id 关联订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canRefundMoney (int $order_id) {
        return self::getClass()->canRefundMoney([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 申请退款
     *
     * @support  int $order_id 关联订单id [Original type uint] [ require true ]
     * @support  string $reason 退款理由 
     * @support  float $money 退款金额 [Original type double] [ require true ]
     * @support  string $type 退款类型 
     * @support  string $account_type 收款账号类型 
     * @support  string $name 用户名/收款单位名称 
     * @support  string $account 收款账号 
     * @support  string $bank_name 开户行名称 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function apply () {
        return self::getClass()->apply();
    }

    /**
     * 退款详情
     *
     * @support  int $id 退款id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 退款列表
     *
     * @support  string $type 类型 [ require true ]
     * @support  string $enterprise_group_name 企业名称 
     * @support  int $status 退款状态 [Original type uint] 
     * @support  int $order_id 订单id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 通过退款
     *
     * @support  int $id 退款id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass () {
        return self::getClass()->pass();
    }

    /**
     * 拒绝退款
     *
     * @support  int $id 退款id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reject () {
        return self::getClass()->reject();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}