<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addAppendPaymentByParams(array $params)
 */
class PaymentRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 追加付款
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  float $pay_money 付款金额 [Original type double] [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $pay_reason 支付原因 [ require true ]
     * @support  string $fluent_num 流水号 
     * @support  string $remark 付款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAppendPayment () {
        return self::getClass()->addAppendPayment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\PaymentRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\PaymentRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}