<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exportPreferentialListByParams(array $params)
 * @method getPreferentialUseInfoByParams(array $params)
 * @method exportPreferentialUseInfoByParams(array $params)
 * @method allGiftCardCoverByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 导出券码列表
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportPreferentialList (int $order_id) {
        return self::getClass()->exportPreferentialList([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取券码使用详情
     *
     * @param  array $search_info 券码创建记录id数组,[[&#039;create_log_id&#039;=&gt;1,&#039;type&#039;=&gt;&#039;coupon&#039;,&#039;amount&#039; =&gt;1]] [ require true ]
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  string $white_list 白名单内容，手机号/邮箱/券码 [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferentialUseInfo (int $order_id, array $search_info = [], string $white_list = '', int $page = 1, int $page_size = 20) {
        return self::getClass()->getPreferentialUseInfo([
            "order_id" => $order_id,
            "search_info" => $search_info,
            "white_list" => $white_list,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 导出券码使用详情
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exportPreferentialUseInfo (int $order_id) {
        return self::getClass()->exportPreferentialUseInfo([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取礼品卡卡面列表(全部)
     *
     * @support  int $topic_id 主题ids [Original type uint] 
     * @support  string $title 卡面标题 
     * @support  bool $has_topic_info 是否包含主题信息 
     * @support  bool $is_on_sale 是否在售 
     * @throws  \Exception
     * @return  array
     */
    public static function allGiftCardCover () {
        return self::getClass()->allGiftCardCover();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}