<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method makeServiceByParams(array $params)
 * @method contractListByParams(array $params)
 * @method createContractByParams(array $params)
 * @method contractDetailByParams(array $params)
 * @method orderListByParams(array $params)
 * @method editContractByParams(array $params)
 * @method deleteContractByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method editOrderByParams(array $params)
 * @method payOrderByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method createPaymentRecordByParams(array $params)
 * @method editPaymentRecordByParams(array $params)
 * @method deletePaymentRecordByParams(array $params)
 * @method paymentRecordListByParams(array $params)
 * @method uploadFinalFileByParams(array $params)
 * @method getBindOrdersByParams(array $params)
 */
class Contract {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * makeService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function makeService () {
        return self::getClass()->makeService();
    }

    /**
     * 查询合同
     *
     * @support  string $start_at 开始日期 
     * @support  string $end_at 结束日期 
     * @support  string $enterprise_name 企业名称 
     * @support  string $customer_phone 客户手机号 
     * @param  int $creator_id 创建人 [Original type uint] [ require true ]
     * @support  bool $is_final_contract 是否为盖印合同 
     * @support  string $contract_type 合同类型，special_contract/normal_contract [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @support  string $contract_no 合同号 
     * @param  string $desc_sort_column 以什么字段倒序 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function contractList (int $creator_id = 0, int $page = 1, int $page_size = 10, string $desc_sort_column = 'created_at') {
        return self::getClass()->contractList([
            "creator_id" => $creator_id,
            "page" => $page,
            "page_size" => $page_size,
            "desc_sort_column" => $desc_sort_column,
        ]);
    }

    /**
     * 创建合同
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [Original type uint] [ require true ]
     * @support  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @support  float $contract_money 合同金额 [Original type double] [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer [ require true ]
     * @support  string $contract_file_path 合同地址 [ require true ]
     * @support  string $contract_file_name 合同名称 [ require true ]
     * @support  string $remark 合同备注 
     * @support  float $discount 折扣 [Original type unsignedDouble] [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createContract () {
        return self::getClass()->createContract();
    }

    /**
     * 合同详情
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function contractDetail (int $id) {
        return self::getClass()->contractDetail([
            "id" => $id,
        ]);
    }

    /**
     * 合同券码订单列表
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页行数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderList (int $id, int $page = 1, int $page_size = 20) {
        return self::getClass()->orderList([
            "id" => $id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 修改合同
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [Original type uint] [ require true ]
     * @support  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @support  float $contract_money 合同金额 [Original type double] [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer [ require true ]
     * @support  string $contract_file_path 合同地址 [ require true ]
     * @support  string $contract_file_name 合同名称 [ require true ]
     * @support  string $remark 合同备注 
     * @support  float $discount 折扣 [Original type unsignedDouble] [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editContract (int $id) {
        return self::getClass()->editContract([
            "id" => $id,
        ]);
    }

    /**
     * 删除合同
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteContract (int $id) {
        return self::getClass()->deleteContract([
            "id" => $id,
        ]);
    }

    /**
     * 合同内创建订单
     *
     * @support  string $order_type 订单类型 [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  array $purchase_info 购买内容 [ require true ]
     * @support  string $consume_method 核销方式 [ require true ]
     * @support  int $white_list_id 白名单id [Original type uint] 
     * @support  string $remark 订单备注 
     * @support  float $origin_price 订单原价 [Original type unsignedDouble] [ require true ]
     * @support  int $contract_id 合同id [Original type uint] [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 合同内删除订单
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder (int $id) {
        return self::getClass()->deleteOrder([
            "id" => $id,
        ]);
    }

    /**
     * 合同内编辑订单
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @support  string $order_type 订单类型 [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  array $purchase_info 购买内容 [ require true ]
     * @support  string $consume_method 核销方式 [ require true ]
     * @support  int $white_list_id 白名单id [Original type uint] 
     * @support  string $remark 订单备注 
     * @support  float $origin_price 订单原价 [Original type unsignedDouble] [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editOrder (int $id) {
        return self::getClass()->editOrder([
            "id" => $id,
        ]);
    }

    /**
     * 合同内订单确认支付
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrder (int $id) {
        return self::getClass()->payOrder([
            "id" => $id,
        ]);
    }

    /**
     * 合同内订单详情
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail (int $id) {
        return self::getClass()->orderDetail([
            "id" => $id,
        ]);
    }

    /**
     * 合同内新增付款
     *
     * @support  int $contract_id 合同id [Original type uint] [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  float $pay_money 付款金额 [Original type double] [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $fluent_num 流水号 
     * @support  string $remark 付款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPaymentRecord () {
        return self::getClass()->createPaymentRecord();
    }

    /**
     * 合同内编辑付款信息
     *
     * @support  int $id 付款记录id [Original type uint] [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  float $pay_money 付款金额 [Original type double] [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @support  string $fluent_num 流水号 
     * @support  string $remark 付款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editPaymentRecord () {
        return self::getClass()->editPaymentRecord();
    }

    /**
     * 合同内删除付款记录
     *
     * @support  int $id 付款记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePaymentRecord () {
        return self::getClass()->deletePaymentRecord();
    }

    /**
     * 获取付款记录列表
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页行数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paymentRecordList (int $id, int $page = 1, int $page_size = 20) {
        return self::getClass()->paymentRecordList([
            "id" => $id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 上传盖印合同
     *
     * @param  int $contract_id 合同id [Original type uint] [ require true ]
     * @param  string $final_file_path 盖印合同文件地址 [ require true ]
     * @param  string $final_file_name 盖印合同文件名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadFinalFile (int $contract_id, string $final_file_path, string $final_file_name) {
        return self::getClass()->uploadFinalFile([
            "contract_id" => $contract_id,
            "final_file_path" => $final_file_path,
            "final_file_name" => $final_file_name,
        ]);
    }

    /**
     * 获取绑定订单列表
     *
     * @param  int $contract_id 合同id [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBindOrders (int $contract_id, int $page = 1, int $page_size = 20) {
        return self::getClass()->getBindOrders([
            "contract_id" => $contract_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Contract');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Contract');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}