<?php
namespace Mainto\Bridge\Invokes\Business\Customer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkCodeByParams(array $params)
 * @method isCheckedByParams(array $params)
 * @method preferentialByParams(array $params)
 * @method receivePreferentialByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 验证验证码
     *
     * @support  string $account 手机号或者email [ require true ]
     * @support  string $code 手机验证码 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $type 账号类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkCode () {
        return self::getClass()->checkCode();
    }

    /**
     * 是否已经验证
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isChecked () {
        return self::getClass()->isChecked();
    }

    /**
     * 获取订单中的优惠券,礼品卡
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function preferential (string $order_no) {
        return self::getClass()->preferential([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 领取优惠券
     *
     * @param  array $item 选择领取的优惠券 [ require true ]
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receivePreferential (array $item, string $order_no) {
        return self::getClass()->receivePreferential([
            "item" => $item,
            "order_no" => $order_no,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Customer\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Customer\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}