<?php
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取Host地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}