<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method approvalHookOnContractByParams(array $params)
 * @method approvalHookOnContractPaymentByParams(array $params)
 * @method approvalHookOnContractPreferentialOrderByParams(array $params)
 * @method approvalHookOnOrderPreferentialOrderByParams(array $params)
 */
class Audit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 合同审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @support  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnContract (string $type, string $EventType) {
        return self::getClass()->approvalHookOnContract([
            "type" => $type,
            "EventType" => $EventType,
        ]);
    }

    /**
     * 合同付款审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @support  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnContractPayment (string $type, string $EventType) {
        return self::getClass()->approvalHookOnContractPayment([
            "type" => $type,
            "EventType" => $EventType,
        ]);
    }

    /**
     * 合同审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @support  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnContractPreferentialOrder (string $type, string $EventType) {
        return self::getClass()->approvalHookOnContractPreferentialOrder([
            "type" => $type,
            "EventType" => $EventType,
        ]);
    }

    /**
     * 合同审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @support  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnOrderPreferentialOrder (string $type, string $EventType) {
        return self::getClass()->approvalHookOnOrderPreferentialOrder([
            "type" => $type,
            "EventType" => $EventType,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Audit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Audit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}