<?php
namespace Mainto\Bridge\Invokes\Business\Customer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateWhiteListGetStatusByParams(array $params)
 * @method checkCodeByParams(array $params)
 * @method isCheckedByParams(array $params)
 * @method preferentialByParams(array $params)
 * @method receivePreferentialByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新白名单领取信息
     *
     * @param  string $channel 渠道号,券码类型拼接订单id和券码create_log_id:coupon_2258_110 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateWhiteListGetStatus (string $channel) {
        return self::getClass()->updateWhiteListGetStatus([
            "channel" => $channel,
        ]);
    }

    /**
     * 验证验证码
     *
     * @support  string $account 手机号或者email [ require true ]
     * @support  string $code 手机验证码 [ require true ]
     * @support  string $type 账号类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkCode () {
        return self::getClass()->checkCode();
    }

    /**
     * 是否已经验证
     *
     * @support  string $account 手机号 [ require true ]
     * @support  string $type 账号类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isChecked () {
        return self::getClass()->isChecked();
    }

    /**
     * 获取订单中的优惠券,礼品卡
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function preferential (string $order_no) {
        return self::getClass()->preferential([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 领取优惠券
     *
     * @param  array $item 选择领取的优惠券 [ require true ]
     * @param  string $account 账户 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receivePreferential (array $item, string $account, string $type) {
        return self::getClass()->receivePreferential([
            "item" => $item,
            "account" => $account,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Customer\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Customer\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}