<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method makeServiceByParams(array $params)
 * @method getPhotoByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * ContractController constructor.
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function makeService () {
        return self::getClass()->makeService();
    }

    /**
     * 获取拍摄照片
     *
     * @param  array $preferential_info 券码创建记录id数组,[[&#039;create_log_id&#039;=&gt;1,&#039;type&#039;=&gt;&#039;coupon&#039;,&#039;amount&#039; =&gt;1]] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhoto (array $preferential_info) {
        return self::getClass()->getPhoto([
            "preferential_info" => $preferential_info,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}