<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method makeServiceByParams(array $params)
 * @method orderListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method payOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method editOrderByParams(array $params)
 * @method payOrderFinalByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * makeService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function makeService () {
        return self::getClass()->makeService();
    }

    /**
     * 查询订单
     *
     * @support  string $order_status 订单状态 
     * @support  string $payment_status 付款状态 
     * @support  string $contract_no 订单的合同编号 
     * @support  bool $staff_pay 是否垫付 
     * @support  string $customer_phone 客户账号 
     * @support  string $order_type 订单类型 
     * @support  string $link 联系人 
     * @support  string $enterprise_name 企业名称 
     * @support  int $creator_id 创建人id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderList (int $page = 1, int $page_size = 10) {
        return self::getClass()->orderList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail (int $id) {
        return self::getClass()->orderDetail([
            "id" => $id,
        ]);
    }

    /**
     * 新增订单
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [Original type uint] [ require true ]
     * @support  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer [ require true ]
     * @support  string $order_type 订单类型 [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  array $purchase_info 购买内容 [ require true ]
     * @support  string $consume_method 核销方式 [ require true ]
     * @support  int $white_list_id 白名单id [Original type uint] 
     * @support  string $remark 订单备注 
     * @support  string $advanced 是否分期 [ require true ]
     * @support  int $staff_pay 垫付伙伴id [Original type uint] 
     * @support  string $staff_phone 垫付伙伴手机号 
     * @support  float $origin_price 订单原价 [Original type unsignedDouble] [ require true ]
     * @support  float $real_pay 订单实际支付 [Original type unsignedDouble] [ require true ]
     * @support  float $discount 折扣 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 确认支付
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  bool $modify 是否修改支付信息 [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  float $pay_money 付款金额 [Original type double] [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 
     * @support  string $fluent_num 流水号 
     * @support  string $remark 付款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrder () {
        return self::getClass()->payOrder();
    }

    /**
     * 删除订单
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder () {
        return self::getClass()->deleteOrder();
    }

    /**
     * 编辑订单
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editOrder () {
        return self::getClass()->editOrder();
    }

    /**
     * 支付尾款
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  float $final_pay_money 尾款 [Original type double] [ require true ]
     * @support  array $evidence 支付凭证 
     * @support  string $fluent_num 流水号 
     * @support  array $change_info 购买物变更信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrderFinal () {
        return self::getClass()->payOrderFinal();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}