<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method makeServiceByParams(array $params)
 * @method enterpriseGroupListByParams(array $params)
 * @method createEnterpriseGroupByParams(array $params)
 * @method enterpriseGroupDetailByParams(array $params)
 * @method editEnterpriseGroupByParams(array $params)
 * @method addEnterpriseByParams(array $params)
 * @method editEnterpriseByParams(array $params)
 * @method deleteEnterpriseByParams(array $params)
 * @method getEnterpriseByParams(array $params)
 */
class Enterprise {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * makeService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function makeService () {
        return self::getClass()->makeService();
    }

    /**
     * 获取企业组列表
     *
     * @param  string $link 客户姓名 [ require true ]
     * @param  string $enterprise_group_name 企业名称 [ require true ]
     * @param  string $customer_phone 客户手机号 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function enterpriseGroupList (string $enterprise_group_name = '', string $link = '', string $customer_phone = '', int $page = 1, int $page_size = 10) {
        return self::getClass()->enterpriseGroupList([
            "enterprise_group_name" => $enterprise_group_name,
            "link" => $link,
            "customer_phone" => $customer_phone,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 创建企业组
     *
     * @param  string $enterprise_group_name 企业组名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createEnterpriseGroup (string $enterprise_group_name) {
        return self::getClass()->createEnterpriseGroup([
            "enterprise_group_name" => $enterprise_group_name,
        ]);
    }

    /**
     * 查看企业组详情
     *
     * @param  int $enterprise_group_id 企业组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function enterpriseGroupDetail (int $enterprise_group_id) {
        return self::getClass()->enterpriseGroupDetail([
            "enterprise_group_id" => $enterprise_group_id,
        ]);
    }

    /**
     * 编辑企业组
     *
     * @param  string $enterprise_group_name 企业组名称 [ require true ]
     * @param  int $enterprise_group_id 企业组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editEnterpriseGroup (string $enterprise_group_name, int $enterprise_group_id) {
        return self::getClass()->editEnterpriseGroup([
            "enterprise_group_name" => $enterprise_group_name,
            "enterprise_group_id" => $enterprise_group_id,
        ]);
    }

    /**
     * 添加企业
     *
     * @param  string $enterprise_name 企业名称 [ require true ]
     * @param  int $enterprise_group_id 企业组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addEnterprise (string $enterprise_name, int $enterprise_group_id) {
        return self::getClass()->addEnterprise([
            "enterprise_name" => $enterprise_name,
            "enterprise_group_id" => $enterprise_group_id,
        ]);
    }

    /**
     * 编辑企业
     *
     * @param  string $enterprise_name 企业名称 [ require true ]
     * @param  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editEnterprise (string $enterprise_name, int $enterprise_id) {
        return self::getClass()->editEnterprise([
            "enterprise_name" => $enterprise_name,
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 删除企业
     *
     * @param  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function deleteEnterprise (int $enterprise_id) {
        return self::getClass()->deleteEnterprise([
            "enterprise_id" => $enterprise_id,
        ]);
    }

    /**
     * 获取企业
     *
     * @param  string $enterprise_name 企业名称 [ require true ]
     * @param  int $enterprise_group_id 企业组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getEnterprise (string $enterprise_name = '', int $enterprise_group_id = 0) {
        return self::getClass()->getEnterprise([
            "enterprise_name" => $enterprise_name,
            "enterprise_group_id" => $enterprise_group_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Enterprise');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Enterprise');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}