<?php
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getAllProvinceByParams(array $params)
 * @method getCityByParams(array $params)
 * @method getAreaByParams(array $params)
 * @method getFullNameByParams(array $params)
 * @method getProductPriceByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取Host地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 获取所有省（包括直辖市）
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProvince () {
        return self::getClass()->getAllProvince();
    }

    /**
     * 根据省获取所有市
     *
     * @param  int $province_id 省id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCity (int $province_id) {
        return self::getClass()->getCity([
            "province_id" => $province_id,
        ]);
    }

    /**
     * 根据市获取所有区
     *
     * @param  int $city_id 市id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getArea (int $city_id) {
        return self::getClass()->getArea([
            "city_id" => $city_id,
        ]);
    }

    /**
     * 根据地区id获取全称
     *
     * @param  int $current_id 当前地区id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFullName (int $current_id) {
        return self::getClass()->getFullName([
            "current_id" => $current_id,
        ]);
    }

    /**
     * 根据产品id获取价格配置
     *
     * @param  int $product_id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductPrice (int $product_id) {
        return self::getClass()->getProductPrice([
            "product_id" => $product_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}