<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method makeServiceByParams(array $params)
 * @method exportPreferentialListByParams(array $params)
 * @method getPreferentialUseInfoByParams(array $params)
 * @method createPreferentialTemplateByParams(array $params)
 * @method getPreferentialTemplateByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * makeService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function makeService () {
        return self::getClass()->makeService();
    }

    /**
     * 导出券码列表
     *
     * @param  array $preferential_info 券码创建记录id数组,[[&#039;create_log_id&#039;=&gt;1,&#039;type&#039;=&gt;&#039;coupon&#039;,&#039;amount&#039; =&gt;1]] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exportPreferentialList (array $preferential_info) {
        return self::getClass()->exportPreferentialList([
            "preferential_info" => $preferential_info,
        ]);
    }

    /**
     * 获取券码使用详情
     *
     * @param  array $preferential_info 券码创建记录id数组,[[&#039;create_log_id&#039;=&gt;1,&#039;type&#039;=&gt;&#039;coupon&#039;,&#039;amount&#039; =&gt;1]] [ require true ]
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  string $white_list 白名单内容，手机号/邮箱/券码 [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferentialUseInfo (int $order_id, array $preferential_info, string $white_list = '', int $page = 1, int $page_size = 20) {
        return self::getClass()->getPreferentialUseInfo([
            "order_id" => $order_id,
            "preferential_info" => $preferential_info,
            "white_list" => $white_list,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 创建券码模版
     *
     * @support  string $name 优惠名称 [ require true ]
     * @support  array $extend 拓展信息 [ require true ]
     * @support  string $preferential_type 券码类型 [ require true ]
     * @support  array $limit 优惠限制产品/门店 [ require true ]
     * @support  bool $special 是否可用于单品折扣 
     * @support  int $action_scope 是否包含sku 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPreferentialTemplate () {
        return self::getClass()->createPreferentialTemplate();
    }

    /**
     * 获取券码模版
     *
     * @support  string $preferential_type 券码类型 [ require true ]
     * @support  string $apply_in 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferentialTemplate () {
        return self::getClass()->getPreferentialTemplate();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}