<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method closeByParams(array $params)
 * @method plusCloseByParams(array $params)
 * @method bindHimoOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单管理/我提交的订单/关闭订单
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * 订单审核/关闭订单
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function plusClose (int $id) {
        return self::getClass()->plusClose([
            "id" => $id,
        ]);
    }

    /**
     * 绑定海马体订单
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @support  string $himo_order_no 海马体订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindHimoOrder (int $id) {
        return self::getClass()->bindHimoOrder([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}