<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method approvalHookOnContractByParams(array $params)
 * @method approvalHookOnPaymentByParams(array $params)
 * @method approvalHookOnContractPreferentialOrderByParams(array $params)
 * @method approvalHookOnOrderPreferentialOrderByParams(array $params)
 * @method approvalHookOnOrderShootOrderHQAuditByParams(array $params)
 * @method approvalHookOnOrderShootOrderStoreAuditByParams(array $params)
 */
class Audit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 合同审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @param  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnContract (string $type, string $EventType, string $processInstanceId) {
        return self::getClass()->approvalHookOnContract([
            "type" => $type,
            "EventType" => $EventType,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 合同付款审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @param  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnPayment (string $type, string $EventType, string $processInstanceId) {
        return self::getClass()->approvalHookOnPayment([
            "type" => $type,
            "EventType" => $EventType,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 合同券码订单审批事件回调监听
     * @deprecated
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @param  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnContractPreferentialOrder (string $type, string $EventType, string $processInstanceId) {
        return self::getClass()->approvalHookOnContractPreferentialOrder([
            "type" => $type,
            "EventType" => $EventType,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 非合同券码订单审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @param  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnOrderPreferentialOrder (string $type, string $EventType, string $processInstanceId) {
        return self::getClass()->approvalHookOnOrderPreferentialOrder([
            "type" => $type,
            "EventType" => $EventType,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 非合同拍摄订单总部审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @param  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnOrderShootOrderHQAudit (string $type, string $EventType, string $processInstanceId) {
        return self::getClass()->approvalHookOnOrderShootOrderHQAudit([
            "type" => $type,
            "EventType" => $EventType,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 非合同拍摄订单门店审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @param  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHookOnOrderShootOrderStoreAudit (string $type, string $EventType, string $processInstanceId) {
        return self::getClass()->approvalHookOnOrderShootOrderStoreAudit([
            "type" => $type,
            "EventType" => $EventType,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Audit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Audit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}