<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getStoreListByParams(array $params)
 */
class OrderShoot {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增拍摄订单
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [Original type uint] [ require true ]
     * @support  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer [ require true ]
     * @support  array $purchase_info 购买内容 [ require true ]
     * @support  string $remark 订单备注 
     * @support  string $advanced 是否分期 [ require true ]
     * @support  string $staff_pay 垫付人 
     * @support  string $staff_phone 垫付人手机号 
     * @support  float $origin_price 订单原价 [Original type unsignedDouble] [ require true ]
     * @support  float $real_pay 订单实际支付 [Original type unsignedDouble] [ require true ]
     * @support  float $discount 折扣 [Original type unsignedDouble] [ require true ]
     * @support  array $extend 扩展信息 
     * @support  int $bind_contract_id 绑定的合同id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取门店列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreList () {
        return self::getClass()->getStoreList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\OrderShoot');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\OrderShoot');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}