<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method getStoreListByParams(array $params)
 * @method getProductsByStoreByParams(array $params)
 * @method getProductDetailByParams(array $params)
 * @method payOrderByParams(array $params)
 * @method detailByParams(array $params)
 * @method getPhotoOrderByParams(array $params)
 * @method batchUpdatePhotoOrderStoreByParams(array $params)
 */
class OrderShoot {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄订单列表
     *
     * @support  string $order_status 订单状态 
     * @support  bool $staff_pay 是否垫付 
     * @support  string $payment_status 付款状态 
     * @support  string $contract_no 订单的合同编号 
     * @support  string $enterprise_name 企业名称 
     * @support  string $link 联系人 
     * @support  string $customer_phone 联系电话 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 新增拍摄订单
     *
     * @support  string $customer_phone 客户手机号 [ require true ]
     * @support  string $enterprise_name 企业名称 [ require true ]
     * @support  string $trade 行业 [ require true ]
     * @support  string $link 联系人姓名 [ require true ]
     * @support  int $contract_area 下单地区 [Original type uint] [ require true ]
     * @support  int $enterprise_id 企业id [Original type uint] [ require true ]
     * @support  string $customer_type 顾客类型，old_customer/new_customer [ require true ]
     * @support  array $purchase_info 购买内容 [ require true ]
     * @support  string $remark 订单备注 
     * @support  string $advanced 是否分期 [ require true ]
     * @support  string $staff_pay 垫付人 
     * @support  string $staff_phone 垫付人手机号 
     * @support  float $origin_price 订单原价 [Original type unsignedDouble] [ require true ]
     * @support  float $real_pay 订单实际支付 [Original type unsignedDouble] [ require true ]
     * @support  float $discount 折扣 [Original type unsignedDouble] [ require true ]
     * @support  array $extend 扩展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取门店列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreList () {
        return self::getClass()->getStoreList();
    }

    /**
     * 获取门店所有产品
     *
     * @support  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsByStore () {
        return self::getClass()->getProductsByStore();
    }

    /**
     * 获取产品详情
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductDetail () {
        return self::getClass()->getProductDetail();
    }

    /**
     * 确认支付
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $pay_at 付款日期 [ require true ]
     * @support  float $pay_money 付款金额 [Original type double] [ require true ]
     * @support  string $pay_type 付款方式 [ require true ]
     * @support  array $evidence 支付凭证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payOrder () {
        return self::getClass()->payOrder();
    }

    /**
     * 订单详情
     *
     * @support  int $id 订单合同id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取关联拍摄订单列表
     *
     * @support  int $group_order_id 团购订单ID 
     * @support  string $user_phone 手机号 
     * @support  string $user_name 姓名 
     * @support  string $order_no 订单号 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoOrder () {
        return self::getClass()->getPhotoOrder();
    }

    /**
     * 修改拍摄门店
     *
     * @support  array $data 重新指定的拍摄门店数据集（如：[拍摄订单ID_1=&gt;重新指定的门店ID_1, 拍摄订单ID_2=&gt;重新指定的门店ID_2]） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdatePhotoOrderStore () {
        return self::getClass()->batchUpdatePhotoOrderStore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\OrderShoot');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\OrderShoot');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}