<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method indexByParams(array $params)
 * @method storeByParams(array $params)
 * @method showByParams(array $params)
 * @method updateByParams(array $params)
 * @method destroyByParams(array $params)
 * @method addPriceByParams(array $params)
 * @method listByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品列表
     *
     * @support  string $price_status 是否设置价格 
     * @support  string $name 产品名称 
     * @support  string $brand 产品品牌 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function index (int $page = 1, int $page_size = 10) {
        return self::getClass()->index([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * [&#039;name&#039; =&gt; &#039;style 1&#039;, &#039;color_ids&#039; =&gt; [1, 2]],
     * [&#039;name&#039; =&gt; &#039;style 2&#039;, &#039;color_ids&#039; =&gt; [1, 2, 3]],
     * ])
     *
     * @support  string $brand 品牌 [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  bool $fixed_number 是否固定人数 [ require true ]
     * @support  int $number_of_people 拍摄人数 
     * @support  array $style_extends 产品风格 
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 产品详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function show (int $id) {
        return self::getClass()->show([
            "id" => $id,
        ]);
    }

    /**
     * [&#039;name&#039; =&gt; &#039;style 1&#039;, &#039;color_ids&#039; =&gt; [1, 2]],
     * [&#039;name&#039; =&gt; &#039;style 2&#039;, &#039;color_ids&#039; =&gt; [1, 2, 3]],
     * ])
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $brand 品牌 [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  bool $fixed_number 是否固定人数 [ require true ]
     * @support  int $number_of_people 拍摄人数 [Original type uint] 
     * @support  array $style_extends 风格数组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function destroy (int $id) {
        return self::getClass()->destroy([
            "id" => $id,
        ]);
    }

    /**
     * [&#039;area_id&#039; =&gt; 1, &#039;initial_price&#039; =&gt; 11, &#039;more_one_price&#039;=&gt;22],
     * [&#039;area_id&#039; =&gt; 2, &#039;initial_price&#039; =&gt; 22, &#039;more_one_price&#039;=&gt;33]
     * ])
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  array $price_extends 价格数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPrice (int $id) {
        return self::getClass()->addPrice([
            "id" => $id,
        ]);
    }

    /**
     * 新增订单搜索产品
     *
     * @support  string $name 产品名称 
     * @support  string $brand 产品品牌 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}