<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method indexByParams(array $params)
 * @method storeByParams(array $params)
 * @method updateByParams(array $params)
 * @method destroyByParams(array $params)
 */
class PriceArea {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询价格区域
     *
     * @throws  \Exception
     * @return  array
     */
    public static function index () {
        return self::getClass()->index();
    }

    /**
     * [&#039;id&#039; =&gt; 100, &#039;name&#039; =&gt; &#039;浙江区&#039;],
     * [&#039;id&#039; =&gt; 200, &#039;name&#039; =&gt; &#039;深圳区&#039;],
     * ])
     *
     * @support  string $name 名称 [ require true ]
     * @support  array $area_extends 区域名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * [&#039;id&#039; =&gt; 100, &#039;name&#039; =&gt; &#039;浙江区&#039;],
     * [&#039;id&#039; =&gt; 200, &#039;name&#039; =&gt; &#039;深圳区&#039;],
     * ])
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 [ require true ]
     * @support  array $area_extends 区域名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除价格区域
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function destroy (int $id) {
        return self::getClass()->destroy([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\PriceArea');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\PriceArea');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}