<?php
namespace Mainto\Bridge\Invokes\Business\Customer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method storeByParams(array $params)
 */
class ContractInvoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 申请开票
     *
     * @param  int $contract_id 合同id [Original type uint] [ require true ]
     * @param  int $invoice_id 开票信息id [Original type uint] [ require true ]
     * @param  float $invoice_money 申请发票金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function store (int $contract_id, int $invoice_id, float $invoice_money) {
        return self::getClass()->store([
            "contract_id" => $contract_id,
            "invoice_id" => $invoice_id,
            "invoice_money" => $invoice_money,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Customer\ContractInvoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Customer\ContractInvoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}