<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method indexByParams(array $params)
 * @method storeByParams(array $params)
 * @method updateByParams(array $params)
 * @method destroyByParams(array $params)
 */
class ProductBgColor {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 背景色列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function index () {
        return self::getClass()->index();
    }

    /**
     * 新增背景颜色
     *
     * @support  string $name 颜色 [ require true ]
     * @support  string $color HEX颜色 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 更新背景颜色
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 颜色 
     * @support  string $color HEX颜色 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除背景颜色
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function destroy (int $id) {
        return self::getClass()->destroy([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\ProductBgColor');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\ProductBgColor');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}