<?php
namespace Mainto\Bridge\Invokes\Business\Customer;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method indexByParams(array $params)
 * @method storeByParams(array $params)
 * @method updateByParams(array $params)
 * @method destroyByParams(array $params)
 */
class ReceivingAddress {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 收货地址列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function index () {
        return self::getClass()->index();
    }

    /**
     * 新增收货地址
     *
     * @support  string $recipient_name 收件人 [ require true ]
     * @support  string $recipient_phone 收件手机 [ require true ]
     * @support  array $recipient_city_id 省市区id [ require true ]
     * @support  string $recipient_address 详细收货地址 [ require true ]
     * @support  bool $is_default 是否默认 
     * @throws  \Exception
     * @return  mixed
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 修改收货地址
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $recipient_name 收件人 
     * @support  string $recipient_phone 收件手机 
     * @support  array $recipient_city_id 省市区id 
     * @support  string $recipient_address 详细收货地址 
     * @support  bool $is_default 是否默认 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除收货地址
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function destroy (int $id) {
        return self::getClass()->destroy([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Customer\ReceivingAddress');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Customer\ReceivingAddress');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}