<?php
namespace Mainto\Bridge\Invokes\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method searchStaffByParamsByParams(array $params)
 * @method getStoreByParams(array $params)
 * @method getStaffByStoreByParams(array $params)
 * @method shootingAreaQueryByParams(array $params)
 * @method getShootingAreaFullNameByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取Host地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 通过员工id获取伙伴信息
     *
     * @param  string $query 工号/花名 [ require true ]
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  array
     */
    public static function searchStaffByParams (string $query) {
        return self::getClass()->searchStaffByParams([
            "query" => $query,
        ]);
    }

    /**
     * 获取所有门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStore () {
        return self::getClass()->getStore();
    }

    /**
     * 获取门店下所有员工
     *
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffByStore (int $store_id) {
        return self::getClass()->getStaffByStore([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 获取拍摄区域
     *
     * @support  int $parent_id 父级id [Original type uint] 
     * @support  int $limit_level 限制level [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function shootingAreaQuery () {
        return self::getClass()->shootingAreaQuery();
    }

    /**
     * 获取拍摄区域全称
     *
     * @support  int $parent_id 父级id [Original type uint] 
     * @support  int $current_id 当前id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShootingAreaFullName () {
        return self::getClass()->getShootingAreaFullName();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}