<?php
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method uploadContractByParams(array $params)
 * @method closeByParams(array $params)
 * @method plusCloseByParams(array $params)
 */
class Contract {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我提交的合同/上传合同
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @support  string $file_path 合同文件 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadContract (int $id) {
        return self::getClass()->uploadContract([
            "id" => $id,
        ]);
    }

    /**
     * 合同管理/我提交的合同/关闭合同
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * 合同审核/关闭合同
     *
     * @param  int $id 合同id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function plusClose (int $id) {
        return self::getClass()->plusClose([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Business', 'Manager\Contract');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Business', 'Manager\Contract');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}