<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-16 18:13:11
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MessageConsumeController
 * @method syncPurchaseInByParams(array $params) 金蝶入库单数据同步
 * @method snapCheckByParams(array $params) 库存流水校对
 * @method retailOperateByParams(array $params) 金蝶零售数据同步
 * @method fixedAssetOutByParams(array $params) 金蝶固定资产出库同步
 * @method allocationOutByParams(array $params) 金蝶调拨出库同步
 * @method noticeUnlockNotifyByParams(array $params) 发货通知单解锁重试，发货通知单解锁失败的情况下通过消息队列强制解锁
 * @method otherOutByParams(array $params) 金蝶其他出库同步
 * @method syncPurchaseByParams(array $params) 金蝶采购单数据同步
 * @method allocationOutCloseByParams(array $params) 金蝶调拨出库关闭同步
 * @method unsaleOutByParams(array $params) 金蝶领用出库同步
 * @method processOutByParams(array $params) 金蝶加工单同步
 * @method syncStorageByParams(array $params) 金蝶仓库数据同步
 * @method otherInByParams(array $params) 金蝶其他入库同步
 * @method createSnapByParams(array $params) 创建库存快照
 * @method syncMaterialByParams(array $params) 金蝶物料数据同步
 * @method wmsReceiveNotifyByParams(array $params) 巨沃收货回调通知,sku如果没有完全收货则会发送群消息
 * @method scrapOutByParams(array $params) 金蝶报废出库同步
 */
class MessageConsumeController {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "com.mainto.supply.bill.application.newController.tenant.message.MessageConsumeController";

    /**
     * 金蝶入库单数据同步
     * @return  string
    */
    public static function syncPurchaseIn (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeePurchaseInSyncMessage $kingdeePurchaseInSyncMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncPurchaseIn($kingdeePurchaseInSyncMessage);
    }

    /**
     * 库存流水校对
     * @return  void
    */
    public static function snapCheck (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\StockSnapMessage $stockSnapMessage = null) {
         RpcClass::getClass(self::$serviceName, self::$className)->snapCheck($stockSnapMessage);
    }

    /**
     * 金蝶零售数据同步
     * @return  string
    */
    public static function retailOperate (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeRetailOperateMessage $kingdeeRetailOperateMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retailOperate($kingdeeRetailOperateMessage);
    }

    /**
     * 金蝶固定资产出库同步
     * @return  string
    */
    public static function fixedAssetOut (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\PhpFixedAssetMessageContent $phpFixedAssetMessageContent = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixedAssetOut($phpFixedAssetMessageContent);
    }

    /**
     * 金蝶调拨出库同步
     * @return  string
    */
    public static function allocationOut (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeAllocationOutMessage $kingdeeAllocationOutMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allocationOut($kingdeeAllocationOutMessage);
    }

    /**
     * 发货通知单解锁重试，发货通知单解锁失败的情况下通过消息队列强制解锁
     * @return  void
    */
    public static function noticeUnlockNotify (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\ShipNoticeUnlockNotifyMessage $shipNoticeUnlockNotifyMessage = null) {
         RpcClass::getClass(self::$serviceName, self::$className)->noticeUnlockNotify($shipNoticeUnlockNotifyMessage);
    }

    /**
     * 金蝶其他出库同步
     * @return  string
    */
    public static function otherOut (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeOtherMessage $kingdeeOtherMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->otherOut($kingdeeOtherMessage);
    }

    /**
     * 金蝶采购单数据同步
     * @return  string
    */
    public static function syncPurchase (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeePurchaseSyncMessage $kingdeePurchaseSyncMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncPurchase($kingdeePurchaseSyncMessage);
    }

    /**
     * 金蝶调拨出库关闭同步
     * @return  string
    */
    public static function allocationOutClose (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeAllocationCloseMessage $kingdeeAllocationCloseMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allocationOutClose($kingdeeAllocationCloseMessage);
    }

    /**
     * 金蝶领用出库同步
     * @return  string
    */
    public static function unsaleOut (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeUnsaleMessage $kingdeeUnsaleMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unsaleOut($kingdeeUnsaleMessage);
    }

    /**
     * 金蝶加工单同步
     * @return  string
    */
    public static function processOut (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeProcessOutMessage $kingdeeProcessOutMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->processOut($kingdeeProcessOutMessage);
    }

    /**
     * 金蝶仓库数据同步
     * @return  string
    */
    public static function syncStorage (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\PhpKingdeeStorageSyncMessageContent $phpKingdeeStorageSyncMessageContent = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncStorage($phpKingdeeStorageSyncMessageContent);
    }

    /**
     * 金蝶其他入库同步
     * @return  string
    */
    public static function otherIn (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeOtherMessage $kingdeeOtherMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->otherIn($kingdeeOtherMessage);
    }

    /**
     * 创建库存快照
     * @return  void
    */
    public static function createSnap (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\StockSnapMessage $stockSnapMessage = null) {
         RpcClass::getClass(self::$serviceName, self::$className)->createSnap($stockSnapMessage);
    }

    /**
     * 金蝶物料数据同步
     * @return  string
    */
    public static function syncMaterial (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\KingdeeMaterialSyncMessage $kingdeeMaterialSyncMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncMaterial($kingdeeMaterialSyncMessage);
    }

    /**
     * 巨沃收货回调通知,sku如果没有完全收货则会发送群消息
     * @return  void
    */
    public static function wmsReceiveNotify (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\WmsReceiveNotifyMessage $wmsReceiveNotifyMessage = null) {
         RpcClass::getClass(self::$serviceName, self::$className)->wmsReceiveNotify($wmsReceiveNotifyMessage);
    }

    /**
     * 金蝶报废出库同步
     * @return  string
    */
    public static function scrapOut (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Tenant\Message\Message\PhpScrapMessageContent $phpScrapMessageContent = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->scrapOut($phpScrapMessageContent);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}