<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-20 17:12:30
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class InventoryController
 * @method inventoryApproveByParams(array $params) bms-盘点审批通过
 * @method getPageListByParams(array $params) bms-盘点审批列表
 * @method inventoryReturnByParams(array $params) bms-盘点审批驳回
 * @method inventoryRevokeByParams(array $params) bms-盘点审批撤回
 * @method inventoryDetailByParams(array $params) bms-盘点审批明细
 * @method getExportByParams(array $params) 盘点审批导出
 * @method getSheetReqByParams(array $params) 导出数据提取
 */
class InventoryController {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "InventoryController";

    /**
     * bms-盘点审批通过
     * @return  bool
    */
    public static function inventoryApprove (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Req\InventoryApproveAppReq $inventoryApproveAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inventoryApprove($inventoryApproveAppReq);
    }

    /**
     * bms-盘点审批列表
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList
    */
    public static function getPageList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Req\InventoryPageListAppReq $inventoryPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPageList($inventoryPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList"
        );
    }

    /**
     * bms-盘点审批驳回
     * @return  bool
    */
    public static function inventoryReturn (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Req\InventoryReturnAppReq $inventoryReturnAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inventoryReturn($inventoryReturnAppReq);
    }

    /**
     * bms-盘点审批撤回
     * @return  bool
    */
    public static function inventoryRevoke (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Req\InventoryRevokeAppReq $inventoryRevokeAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inventoryRevoke($inventoryRevokeAppReq);
    }

    /**
     * bms-盘点审批明细
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Res\InventoryDetailRes
    */
    public static function inventoryDetail (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Req\InventoryDetailAppReq $inventoryDetailAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->inventoryDetail($inventoryDetailAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Res\InventoryDetailRes"
        );
    }

    /**
     * 盘点审批导出
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function getExport () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getExport(),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }

    /**
     * 导出数据提取
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Saas\Export\Api\Req\SheetReq
    */
    public static function getSheetReq (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Inventory\Req\InventoryPageListAppReq $inventoryPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSheetReq($inventoryPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Saas\Export\Api\Req\SheetReq"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}