<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-19 10:51:34
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseDues
 * @method autoCreateDueByParams(array $params) 每天五点自动生成应付账单
 * @method submitByParams(array $params) 应付单提交审批
 * @method updateByParams(array $params) 应付单修改
 * @method revokeByParams(array $params) 应付单撤销
 * @method createByOrderByParams(array $params) 创建应付款单（批量）
 * @method getPageListByParams(array $params) 应付单列表
 * @method buildDueExcelByParams(array $params) 生成应付单对应的excel
 * @method dueDingCallbackByParams(array $params) 应付单钉钉审批回调
 * @method createByParams(array $params) 创建应付款单
 * @method itemListByParams(array $params) 应付单明细列表
 * @method detailByParams(array $params) 应付单详情
 * @method closeByParams(array $params) 应付单关闭
 * @method buildExcelJobByParams(array $params) 重新推送生成预付单excelJOB
 */
class PurchaseDues {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "PurchaseDues";

    /**
     * 每天五点自动生成应付账单
     * @return  bool
    */
    public static function autoCreateDue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCreateDue();
    }

    /**
     * 应付单提交审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function submit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit([]);
    }

    /**
     * 应付单修改
     * @return  bool
    */
    public static function update (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Req\PurchaseDueUpdateAppReq $purchaseDueUpdateAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($purchaseDueUpdateAppReq);
    }

    /**
     * 应付单撤销
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function revoke () {
        return RpcClass::getClass(self::$serviceName, self::$className)->revoke([]);
    }

    /**
     * 创建应付款单（批量）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function createByOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->createByOrder([]);
    }

    /**
     * 应付单列表
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDuePageListRes
    */
    public static function getPageList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Req\PurchaseDuePageListAppReq $purchaseDuePageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPageList($purchaseDuePageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDuePageListRes"
        );
    }

    /**
     * 生成应付单对应的excel
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function buildDueExcel () {
        return RpcClass::getClass(self::$serviceName, self::$className)->buildDueExcel([]);
    }

    /**
     * 应付单钉钉审批回调
     * @return  string
    */
    public static function dueDingCallback (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Common\Model\Req\DingCallBackReq $dingCallBackReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dueDingCallback($dingCallBackReq);
    }

    /**
     * 创建应付款单
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDueDetailRes
    */
    public static function create (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Req\PurchaseDueCreateAppReq $purchaseDueCreateAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->create($purchaseDueCreateAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDueDetailRes"
        );
    }

    /**
     * 应付单明细列表
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDueItemPageListRes
    */
    public static function itemList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Req\PurchaseDueItemPageListAppReq $purchaseDueItemPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->itemList($purchaseDueItemPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDueItemPageListRes"
        );
    }

    /**
     * 应付单详情
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDueDetailRes
    */
    public static function detail (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Req\PurchaseDueDetailAppReq $purchaseDueDetailAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail($purchaseDueDetailAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\PurchaseDue\Model\Res\PurchaseDueDetailRes"
        );
    }

    /**
     * 应付单关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close () {
        return RpcClass::getClass(self::$serviceName, self::$className)->close([]);
    }

    /**
     * 重新推送生成预付单excelJOB
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function buildExcelJob () {
        return RpcClass::getClass(self::$serviceName, self::$className)->buildExcelJob([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}