<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-13 17:44:58
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseDemandPool
 * @method createWebSocketLinkByParams(array $params) 创建需求池webSocket链接
 * @method delAllPurchaseDemandPoolByParams(array $params) 清空需求池全部记录
 * @method getDemandPoolResultByParams(array $params) 查看指定需求池处理结果
 * @method batchDealPoolPurchaseOrderByParams(array $params) 处理需求池子任务采购单
 * @method dealPoolAbortCompleteByParams(array $params) 需求池子任务中断处理
 * @method clearPoolRedisDataByParams(array $params) 清理需求池缓存
 * @method checkClosedPoolByParams(array $params) 每小时判断是否需要提示需求池主任务，判断创建单子超过 1 小时
 * @method operateDealPoolConnectByParams(array $params) 创建用户需求池连接
 * @method demandItemBatchPoolByParams(array $params) 批量处理并开启需求处理
 * @method autoClosedPoolByParams(array $params) 每分钟判断是否需要关闭掉需求池主任务，判断创建单子超过 1 小时，并且子单已经全部标记为已处理
 * @method acceptDemandItemBatchPoolByParams(array $params) 需求池延迟处理回调接收
 * @method batchDealPoolAllocationByParams(array $params) 处理需求池子任务调拨单
 * @method getPurchaseDemandPoolPageListByParams(array $params) 需求池列表(分页)
 * @method delPurchaseDemandPoolByParams(array $params) 删除需求池记录
 * @method getManyPoolWebSocketMsgByParams(array $params) 查看需求池使用数据
 * @method monitorRoomLinkByParams(array $params) 
 * @method dealPoolCompleteByParams(array $params) 需求池子任务全部处理完成
 * @method demandItemFilterByParams(array $params) 一件筛选可处理需求子单
 * @method removeCompletePoolByParams(array $params) 关闭成功通知
 * @method getExportByParams(array $params) 下载处理建议
 * @method addPurchaseDemandPoolByParams(array $params) 添加到需求池
 * @method batchDealPurchaseDemandPoolByParams(array $params) 开启批量处理需求池记录
 * @method poolDelayRunJobByParams(array $params) 子任务拆分完成后，开启需求池任务处理，延迟 x 秒开启
 * @method poolDelayRecoveryByParams(array $params) 需求池子单超时保底处理
 * @method dealResultPurchaseDemandPoolListByParams(array $params) 需求池处理结果列表
 * @method lastDealResultPurchaseDemandPoolByParams(array $params) 查看上次需求池处理结果
 */
class PurchaseDemandPool {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "PurchaseDemandPool";

    /**
     * 创建需求池webSocket链接
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\CreateWebSocketLinkRes
    */
    public static function createWebSocketLink () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createWebSocketLink(),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\CreateWebSocketLinkRes"
        );
    }

    /**
     * 清空需求池全部记录
     * @return  bool
    */
    public static function delAllPurchaseDemandPool () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delAllPurchaseDemandPool();
    }

    /**
     * 查看指定需求池处理结果
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\LastDealResultPurchaseDemandPoolRes
    */
    public static function getDemandPoolResult () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDemandPoolResult([]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\LastDealResultPurchaseDemandPoolRes"
        );
    }

    /**
     * 处理需求池子任务采购单
     * @return  bool
    */
    public static function batchDealPoolPurchaseOrder (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\DealPoolPurchaseOrderListReq $dealPoolPurchaseOrderListReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDealPoolPurchaseOrder($dealPoolPurchaseOrderListReq);
    }

    /**
     * 需求池子任务中断处理
     * @return  bool
    */
    public static function dealPoolAbortComplete (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\DealPoolCompleteReq $dealPoolCompleteReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dealPoolAbortComplete($dealPoolCompleteReq);
    }

    /**
     * 清理需求池缓存
     * @return  void
    */
    public static function clearPoolRedisData () {
         RpcClass::getClass(self::$serviceName, self::$className)->clearPoolRedisData();
    }

    /**
     * 每小时判断是否需要提示需求池主任务，判断创建单子超过 1 小时
     * @return  void
    */
    public static function checkClosedPool () {
         RpcClass::getClass(self::$serviceName, self::$className)->checkClosedPool();
    }

    /**
     * 创建用户需求池连接
     * @return  bool
    */
    public static function operateDealPoolConnect (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\OperateDealPoolConnectReq $operateDealPoolConnectReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->operateDealPoolConnect($operateDealPoolConnectReq);
    }

    /**
     * 批量处理并开启需求处理
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function demandItemBatchPool () {
        return RpcClass::getClass(self::$serviceName, self::$className)->demandItemBatchPool([]);
    }

    /**
     * 每分钟判断是否需要关闭掉需求池主任务，判断创建单子超过 1 小时，并且子单已经全部标记为已处理
     * @return  void
    */
    public static function autoClosedPool () {
         RpcClass::getClass(self::$serviceName, self::$className)->autoClosedPool();
    }

    /**
     * 需求池延迟处理回调接收
     * @return  bool
    */
    public static function acceptDemandItemBatchPool (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\ToBatchDealPoolReq $toBatchDealPoolReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->acceptDemandItemBatchPool($toBatchDealPoolReq);
    }

    /**
     * 处理需求池子任务调拨单
     * @return  bool
    */
    public static function batchDealPoolAllocation (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\DealPoolAllocationListReq $dealPoolAllocationListReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDealPoolAllocation($dealPoolAllocationListReq);
    }

    /**
     * 需求池列表(分页)
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\PurchaseDemandPoolPageListRes
    */
    public static function getPurchaseDemandPoolPageList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\PurchaseDemandPoolPageListReq $purchaseDemandPoolPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseDemandPoolPageList($purchaseDemandPoolPageListReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\PurchaseDemandPoolPageListRes"
        );
    }

    /**
     * 删除需求池记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delPurchaseDemandPool () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delPurchaseDemandPool([]);
    }

    /**
     * 查看需求池使用数据
     * @return  string
    */
    public static function getManyPoolWebSocketMsg () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getManyPoolWebSocketMsg();
    }

    /**
     * 
     * @return  void
    */
    public static function monitorRoomLink () {
         RpcClass::getClass(self::$serviceName, self::$className)->monitorRoomLink();
    }

    /**
     * 需求池子任务全部处理完成
     * @return  bool
    */
    public static function dealPoolComplete (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\JobOverCallbackMessage $jobOverCallbackMessage = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dealPoolComplete($jobOverCallbackMessage);
    }

    /**
     * 一件筛选可处理需求子单
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\DemandItemFilterRes
    */
    public static function demandItemFilter (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\PurchaseDemandItemPageListReq $purchaseDemandItemPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->demandItemFilter($purchaseDemandItemPageListReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\DemandItemFilterRes"
        );
    }

    /**
     * 关闭成功通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function removeCompletePool () {
         RpcClass::getClass(self::$serviceName, self::$className)->removeCompletePool([]);
    }

    /**
     * 下载处理建议
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function getExport (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\DealPoolCompleteReq $dealPoolCompleteReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getExport($dealPoolCompleteReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }

    /**
     * 添加到需求池
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\AddDemandPoolRes
    */
    public static function addPurchaseDemandPool () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->addPurchaseDemandPool([]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\AddDemandPoolRes"
        );
    }

    /**
     * 开启批量处理需求池记录
     * @return  bool
    */
    public static function batchDealPurchaseDemandPool () {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDealPurchaseDemandPool();
    }

    /**
     * 子任务拆分完成后，开启需求池任务处理，延迟 x 秒开启
     * @return  bool
    */
    public static function poolDelayRunJob (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\DelayRunJobReq $delayRunJobReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->poolDelayRunJob($delayRunJobReq);
    }

    /**
     * 需求池子单超时保底处理
     * @return  bool
    */
    public static function poolDelayRecovery (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\DelayRunJobReq $delayRunJobReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->poolDelayRecovery($delayRunJobReq);
    }

    /**
     * 需求池处理结果列表
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\DealResultPurchaseDemandPoolPageRes
    */
    public static function dealResultPurchaseDemandPoolList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\PurchaseDemandPoolPageListReq $purchaseDemandPoolPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->dealResultPurchaseDemandPoolList($purchaseDemandPoolPageListReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\DealResultPurchaseDemandPoolPageRes"
        );
    }

    /**
     * 查看上次需求池处理结果
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\LastDealResultPurchaseDemandPoolRes
    */
    public static function lastDealResultPurchaseDemandPool () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lastDealResultPurchaseDemandPool(),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\LastDealResultPurchaseDemandPoolRes"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}