<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-16 18:28:23
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class StoreInventoryController
 * @method getWaitSubmitInventoryDetailWithSkuAndStockByParams(array $params) 获取零售待盘点全量详情,带sku,分类及库存
 * @method getStoreInventoryPageListByParams(array $params) 获取门店端盘点分页列表
 * @method inventoryCheckImportByParams(array $params) 提交盘点单-导入
 * @method getSelfInventoryDetailAndItemPageWithSkuAndStockByParams(array $params) 获取自用待盘点分页详情,带sku,分类及库存
 * @method getSelfInventoryDetailAndAllItemWithSkuAndStockByParams(array $params) 门店自用盘点详情,当盘点单为待提交时获取自用待盘点详情全量List,带sku,分类及库存 
 * @method inventoryLimitedDateCheckDownloadTemplateByParams(array $params) 限用日期盘点物料导出模板下载
 * @method getRetailAllSkuListWithStockByParams(array $params) 零售盘点，添加全部产品物料sku以及对应库存
 * @method inventoryLimitedDateCheckByParams(array $params) 限用日期物料盘点提交
 * @method inventoryCheckDownloadTemplateByParams(array $params) 正常盘点物料导出模板下载
 * @method inventoryLimitedDateStockListByParams(array $params) 限用日期盘点物料库存查询
 * @method inventoryRevokeByParams(array $params) 盘点单撤回
 * @method retailInventoryNoticeByParams(array $params) 盘点提醒-零售
 * @method getRetailInventoryDetailAndItemPageWithProductAndStockByParams(array $params) 获取零售待盘点分页详情,带sku产品,分类及库存
 * @method getStoreStockBySkuIdsByParams(array $params) 根据门店和sku获取库存
 * @method adventNoticeByParams(array $params) 门店物料临期通知
 * @method expireNoticeByParams(array $params) 过期物料处理待办
 * @method inventoryCheckByParams(array $params) 提交盘点单
 * @method inventoryLimitedDateCheckImportByParams(array $params) 限用日期物料盘点提交-导入
 * @method retailInventorySaveByParams(array $params) 零售提交盘点单
 * @method selfInventoryNoticeByParams(array $params) 盘点提醒-自用
 */
class StoreInventoryController {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "com.mainto.supply.bill.application.newController.store.inventory.StoreInventoryController";

    /**
     * 获取零售待盘点全量详情,带sku,分类及库存
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\RetailDetailWithSkuAndStockRes
    */
    public static function getWaitSubmitInventoryDetailWithSkuAndStock (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\RetailInventorySearchReq $retailInventorySearchReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getWaitSubmitInventoryDetailWithSkuAndStock($retailInventorySearchReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\RetailDetailWithSkuAndStockRes"
        );
    }

    /**
     * 获取门店端盘点分页列表
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreInventoryPageListRes
    */
    public static function getStoreInventoryPageList (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\RetailInventoryPageListSearchReq $retailInventoryPageListSearchReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreInventoryPageList($retailInventoryPageListSearchReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreInventoryPageListRes"
        );
    }

    /**
     * 提交盘点单-导入
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function inventoryCheckImport (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryCheckReq $inventoryCheckReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->inventoryCheckImport($inventoryCheckReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }

    /**
     * 获取自用待盘点分页详情,带sku,分类及库存
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreSelfInventoryDetailRes
    */
    public static function getSelfInventoryDetailAndItemPageWithSkuAndStock (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\RetailInventorySearchReq $retailInventorySearchReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSelfInventoryDetailAndItemPageWithSkuAndStock($retailInventorySearchReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreSelfInventoryDetailRes"
        );
    }

    /**
     * 门店自用盘点详情,当盘点单为待提交时获取自用待盘点详情全量List,带sku,分类及库存 
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreSelfInventoryDetailWithAllItemRes
    */
    public static function getSelfInventoryDetailAndAllItemWithSkuAndStock (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\RetailInventorySearchReq $retailInventorySearchReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSelfInventoryDetailAndAllItemWithSkuAndStock($retailInventorySearchReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreSelfInventoryDetailWithAllItemRes"
        );
    }

    /**
     * 限用日期盘点物料导出模板下载
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function inventoryLimitedDateCheckDownloadTemplate (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryCheckDownloadTemplateReq $inventoryCheckDownloadTemplateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->inventoryLimitedDateCheckDownloadTemplate($inventoryCheckDownloadTemplateReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }

    /**
     * 零售盘点，添加全部产品物料sku以及对应库存
     * @return  array
    */
    public static function getRetailAllSkuListWithStock () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRetailAllSkuListWithStock(),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Isolate\Model\Vo\InventorySkuVO[]"
        );
    }

    /**
     * 限用日期物料盘点提交
     * @return  bool
    */
    public static function inventoryLimitedDateCheck (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryLimitedDateCheckReq $inventoryLimitedDateCheckReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inventoryLimitedDateCheck($inventoryLimitedDateCheckReq);
    }

    /**
     * 正常盘点物料导出模板下载
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function inventoryCheckDownloadTemplate (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryCheckDownloadTemplateReq $inventoryCheckDownloadTemplateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->inventoryCheckDownloadTemplate($inventoryCheckDownloadTemplateReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }

    /**
     * 限用日期盘点物料库存查询
     * @return  array
    */
    public static function inventoryLimitedDateStockList (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\StoreStockSearchReq $storeStockSearchReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->inventoryLimitedDateStockList($storeStockSearchReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Isolate\Model\Vo\StoreInventoryDetailInfoRes[]"
        );
    }

    /**
     * 盘点单撤回
     * @return  bool
    */
    public static function inventoryRevoke (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\StoreInventoryRevokeReq $storeInventoryRevokeReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inventoryRevoke($storeInventoryRevokeReq);
    }

    /**
     * 盘点提醒-零售
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\InventoryNoticeRes
    */
    public static function retailInventoryNotice (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryNoticeReq $inventoryNoticeReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->retailInventoryNotice($inventoryNoticeReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\InventoryNoticeRes"
        );
    }

    /**
     * 获取零售待盘点分页详情,带sku产品,分类及库存
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreRetailInventoryDetailRes
    */
    public static function getRetailInventoryDetailAndItemPageWithProductAndStock (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\RetailInventorySearchReq $retailInventorySearchReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRetailInventoryDetailAndItemPageWithProductAndStock($retailInventorySearchReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\StoreRetailInventoryDetailRes"
        );
    }

    /**
     * 根据门店和sku获取库存
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getStoreStockBySkuIds (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\StoreStockSearchReq $storeStockSearchReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreStockBySkuIds($storeStockSearchReq);
    }

    /**
     * 门店物料临期通知
     * @return  void
    */
    public static function adventNotice () {
         RpcClass::getClass(self::$serviceName, self::$className)->adventNotice();
    }

    /**
     * 过期物料处理待办
     * @return  void
    */
    public static function expireNotice () {
         RpcClass::getClass(self::$serviceName, self::$className)->expireNotice();
    }

    /**
     * 提交盘点单
     * @return  bool
    */
    public static function inventoryCheck (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryCheckReq $inventoryCheckReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->inventoryCheck($inventoryCheckReq);
    }

    /**
     * 限用日期物料盘点提交-导入
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function inventoryLimitedDateCheckImport (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryLimitedDateCheckReq $inventoryLimitedDateCheckReq) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->inventoryLimitedDateCheckImport($inventoryLimitedDateCheckReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }

    /**
     * 零售提交盘点单
     * @return  bool
    */
    public static function retailInventorySave (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\RetailInventorySaveReq $retailInventorySaveReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retailInventorySave($retailInventorySaveReq);
    }

    /**
     * 盘点提醒-自用
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\InventoryNoticeRes
    */
    public static function selfInventoryNotice (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Req\InventoryNoticeReq $inventoryNoticeReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->selfInventoryNotice($inventoryNoticeReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\NewController\Store\Inventory\Res\InventoryNoticeRes"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}