<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-02 18:14:52
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class LogisticAppController
 * @method getPageListByParams(array $params) 快递详情查看
 * @method getExpressListByParams(array $params) 查看主单对应的物流单号
 * @method updateSubscribeByParams(array $params) 快递内容回调
 * @method getExpressTypeAllByParams(array $params) 快递列表
 * @method expressDeliveryCreateEventByParams(array $params) 物流订阅
 */
class LogisticAppController {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "LogisticAppController";

    /**
     * 快递详情查看
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Logistics\Res\DetailAppRes
    */
    public static function getPageList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPageList([]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Logistics\Res\DetailAppRes"
        );
    }
    /**
     * 查看主单对应的物流单号
     * @return  array
    */
    public static function getExpressList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExpressList([]);
    }
    /**
     * 快递内容回调
     * @return  bool
    */
    public static function updateSubscribe (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Logistics\Req\LogisticSubscribeAppReq $logisticSubscribeAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSubscribe($logisticSubscribeAppReq);
    }
    /**
     * 快递列表
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Logistics\Res\SaasExpressDeliveryTypeListAppRes
    */
    public static function getExpressTypeAll () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getExpressTypeAll(),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Logistics\Res\SaasExpressDeliveryTypeListAppRes"
        );
    }
    /**
     * 物流订阅
     * @return  void
    */
    public static function expressDeliveryCreateEvent (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Logistics\Req\ExpressDeliveryCreateReq $expressDeliveryCreateReq = null) {
         RpcClass::getClass(self::$serviceName, self::$className)->expressDeliveryCreateEvent($expressDeliveryCreateReq);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}