<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-29 17:26:37
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ScrapMission
 * @method getMissionDetailItemListByParams(array $params) 报废任务详情(物料列表)
 * @method getScrapPageListByParams(array $params) 报废审批列表(门店适配需要做对应修改)
 * @method getDetailByParams(array $params) 报废审批详情(基本信息)
 * @method getMissionDetailByParams(array $params) 报废任务详情(基本信息)
 * @method getMissionDetailScrapPageListByParams(array $params) 报废任务详情(门店列表)
 * @method revokeByParams(array $params) 报废任务撤回
 * @method getScrapSkuLiveByParams(array $params) 报废任务中的生命周期
 * @method getExportByParams(array $params) 导出报废任务详情
 * @method getSheetReqByParams(array $params) 导出数据提取
 * @method getMissionPageListByParams(array $params) 报废任务列表
 * @method bmsBatchCreateByParams(array $params) 报废任务bms创建
 */
class ScrapMission {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "ScrapMission";

    /**
     * 报废任务详情(物料列表)
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList
    */
    public static function getMissionDetailItemList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Req\ScrapMissionItemPageListAppReq $scrapMissionItemPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMissionDetailItemList($scrapMissionItemPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList"
        );
    }
    /**
     * 报废审批列表(门店适配需要做对应修改)
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList
    */
    public static function getScrapPageList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Req\ScrapPageListAppReq $scrapPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getScrapPageList($scrapPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList"
        );
    }
    /**
     * 报废审批详情(基本信息)
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\DetailAggregate
    */
    public static function getDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDetail([]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\DetailAggregate"
        );
    }
    /**
     * 报废任务详情(基本信息)
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Res\ScrapMissionRes
    */
    public static function getMissionDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMissionDetail([]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Res\ScrapMissionRes"
        );
    }
    /**
     * 报废任务详情(门店列表)
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList
    */
    public static function getMissionDetailScrapPageList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Req\ScrapPageListAppReq $scrapPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMissionDetailScrapPageList($scrapPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList"
        );
    }
    /**
     * 报废任务撤回
     * @return  bool
    */
    public static function revoke () {
        return RpcClass::getClass(self::$serviceName, self::$className)->revoke([]);
    }
    /**
     * 报废任务中的生命周期
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Res\SkuLiveScrapRes
    */
    public static function getScrapSkuLive () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getScrapSkuLive([]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Res\SkuLiveScrapRes"
        );
    }
    /**
     * 导出报废任务详情
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function getExport (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Req\ScrapPageListAppReq $scrapPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getExport($scrapPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }
    /**
     * 导出数据提取
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Saas\Export\Api\Req\SheetReq
    */
    public static function getSheetReq (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Req\ScrapPageListAppReq $scrapPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSheetReq($scrapPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Saas\Export\Api\Req\SheetReq"
        );
    }
    /**
     * 报废任务列表
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList
    */
    public static function getMissionPageList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Req\ScrapMissionPageListAppReq $scrapMissionPageListAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMissionPageList($scrapMissionPageListAppReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Stock\Common\PageList"
        );
    }
    /**
     * 报废任务bms创建
     * @return  int
    */
    public static function bmsBatchCreate (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Scrap\Req\ScrapMissionCreateAppReq $scrapMissionCreateAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bmsBatchCreate($scrapMissionCreateAppReq);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}