<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-21 13:56:51
 */
namespace Mainto\Bridge\Invokes\BscSupplyStock;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PurchaseDemandItemAppService
 */
class PurchaseDemandItemAppService {
    private static string $serviceName = "BscSupplyStock";

    private static string $className = "PurchaseDemandItemAppService";

    /**
     * 批量更新需求子单状态,php接口使用
     * @return  bool
    */
    public static function batchUpdateDemandStatusPhp (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\BatchUpdateDemandStatusPhpReq $batchUpdateDemandStatusPhpReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateDemandStatusPhp($batchUpdateDemandStatusPhpReq);
    }
    /**
     * 获取采购条数限制
     * @return  array
    */
    public static function getPurchaseCountLimit (array $skuIdList) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseCountLimit(["skuIdList" => $skuIdList]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\PurchaseCountLimitRes[]"
        );
    }
    /**
     * 批量更新需求子单状态
     * @return  bool
    */
    public static function batchUpdateDemandStatus (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\BatchUpdateDemandStatusReq $batchUpdateDemandStatusReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateDemandStatus($batchUpdateDemandStatusReq);
    }
    /**
     * 获取门店水位限制
     * @return  array
    */
    public static function getPurchaseCountLimitForRpc (array $skuIdList, int $storeId, int $tenantId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseCountLimitForRpc(["skuIdList" => $skuIdList, "storeId" => $storeId, "tenantId" => $tenantId]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\PurchaseCountLimitRes[]"
        );
    }
    /**
     * 需求单明细列表导出
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes
    */
    public static function getExport (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\PurchaseDemandItemPageListReq $purchaseDemandItemPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getExport($purchaseDemandItemPageListReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\ExportRes"
        );
    }
    /**
     * 需求单批量关闭
     * @return  bool
    */
    public static function closeDemandItems (\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\DemandItemCloseAppReq $demandItemCloseAppReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeDemandItems($demandItemCloseAppReq);
    }
    /**
     * 需求单明细列表(分页)
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\PurchaseDemandItemPageListRes
    */
    public static function getPurchaseDemandItemPageList (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\PurchaseDemandItemPageListReq $purchaseDemandItemPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseDemandItemPageList($purchaseDemandItemPageListReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\PurchaseDemandItemPageListRes"
        );
    }
    /**
     * 导出回调查询
     * @return  \Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Saas\Export\Api\Req\SheetReq
    */
    public static function getSheetReq (?\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Req\PurchaseDemandItemPageListReq $purchaseDemandItemPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSheetReq($purchaseDemandItemPageListReq),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bsc\Supply\Saas\Export\Api\Req\SheetReq"
        );
    }
    /**
     * 获取仓库水位限制
     * @return  array
    */
    public static function getPurchaseCountLimitForRpcByStorageId (array $skuIdList, int $storageId, int $tenantId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseCountLimitForRpcByStorageId(["skuIdList" => $skuIdList, "storageId" => $storageId, "tenantId" => $tenantId]),
            "\Mainto\Bridge\Structs\BscSupplyStock\Com\Mainto\Supply\Bill\Application\Controller\Demand\Model\Res\PurchaseCountLimitRes[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}