<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-09 18:05:36
 */
namespace Mainto\Bridge\Invokes\BscSupplySaasWarehouse;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class StorageAppServiceImpl
 * @method getStorageAggregateByParams(array $params) 查找仓库详情信息
 * @method syncTenantStorageByParams(array $params) 根据租户id更新全量仓库（以自用仓为基础）
 * @method getStorageTypeListByParams(array $params) 查找仓库类型
 * @method createStorageByParams(array $params) 创建仓库
 * @method getExpressDeliveryTypesListByParams(array $params) 查找快递类型列表
 * @method getSupplierStorageSelectorByParams(array $params) 
 * @method getRecentByParams(array $params) 近7天创建需求方
 * @method storageTagSearchByParams(array $params) 需绑定需求方查看
 * @method getAllSelectorByParams(array $params) 
 * @method getSelectorByParams(array $params) 
 * @method updateWmsStorageCodesByParams(array $params) wms更新
 * @method getStorageByParams(array $params) 查找仓库
 * @method getWmsStorageCodesDtoByParams(array $params) wms查询
 * @method searchStorageByParams(array $params) 查找全量仓库
 * @method getStorageListByParams(array $params) 查找全量仓库-分页
 * @method storageUpdateByParams(array $params) 更新仓库
 */
class StorageAppServiceImpl {
    private static string $serviceName = "BscSupplySaasWarehouse";

    private static string $className = "StorageAppServiceImpl";

    /**
     * 查找仓库详情信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes
    */
    public static function getStorageAggregate (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageSearchReq $storageSearchReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStorageAggregate($storageSearchReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes"
        );
    }

    /**
     * 根据租户id更新全量仓库（以自用仓为基础）
     * @return  bool
    */
    public static function syncTenantStorage (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\TenantStorageSyncAppReq $tenantStorageSyncAppReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncTenantStorage($tenantStorageSyncAppReq);
    }

    /**
     * 查找仓库类型
     * @return  array
    */
    public static function getStorageTypeList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStorageTypeList(),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageTypeRes[]"
        );
    }

    /**
     * 创建仓库
     * @return  \Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes
    */
    public static function createStorage (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageCreateAppReq $storageCreateAppReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createStorage($storageCreateAppReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes"
        );
    }

    /**
     * 查找快递类型列表
     * @return  array
    */
    public static function getExpressDeliveryTypesList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getExpressDeliveryTypesList(),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppExpressDeliveryTypesRes[]"
        );
    }

    /**
     * 
     * @return  array
    */
    public static function getSupplierStorageSelector (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageTagSelectorSearchReq $storageTagSelectorSearchReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSupplierStorageSelector($storageTagSelectorSearchReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\SelectorAppRes[]"
        );
    }

    /**
     * 近7天创建需求方
     * @return  array
    */
    public static function getRecent () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRecent(),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes[]"
        );
    }

    /**
     * 需绑定需求方查看
     * @return  array
    */
    public static function storageTagSearch (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageTagSearchReq $storageTagSearchReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storageTagSearch($storageTagSearchReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes[]"
        );
    }

    /**
     * 
     * @return  array
    */
    public static function getAllSelector (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageTagSelectorSearchReq $storageTagSelectorSearchReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllSelector($storageTagSelectorSearchReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\SelectorAppRes[]"
        );
    }

    /**
     * 
     * @return  array
    */
    public static function getSelector (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageTagSelectorSearchReq $storageTagSelectorSearchReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSelector($storageTagSelectorSearchReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\SelectorAppRes[]"
        );
    }

    /**
     * wms更新
     * @return  bool
    */
    public static function updateWmsStorageCodes (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\AppStorageWmsCodeCreateReq $appStorageWmsCodeCreateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateWmsStorageCodes($appStorageWmsCodeCreateReq);
    }

    /**
     * 查找仓库
     * @return  \Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes
    */
    public static function getStorage (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageSearchReq $storageSearchReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStorage($storageSearchReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes"
        );
    }

    /**
     * wms查询
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\WmsStorageCodesRes
    */
    public static function getWmsStorageCodesDto () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getWmsStorageCodesDto([]),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\WmsStorageCodesRes"
        );
    }

    /**
     * 查找全量仓库
     * @return  array
    */
    public static function searchStorage (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\StorageSearchReq $storageSearchReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchStorage($storageSearchReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes[]"
        );
    }

    /**
     * 查找全量仓库-分页
     * @return  \Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageAggregateRes
    */
    public static function getStorageList (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\AppStorageAggregateReq $appStorageAggregateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStorageList($appStorageAggregateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageAggregateRes"
        );
    }

    /**
     * 更新仓库
     * @return  \Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes
    */
    public static function storageUpdate (?\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Req\AppStorageUpdateReq $appStorageUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storageUpdate($appStorageUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasWarehouse\Com\Mainto\Supply\Bsc\Supply\Saas\Warehouse\Application\Api\Res\AppStorageRes"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}