<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-07-10 14:31:16
 */
namespace Mainto\Bridge\Invokes\BscSupplySaasMaterial;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SkuController
 * @method getSkuListByParams(array $params) sku列表
 * @method updateSkuMaterialTagBindByParams(array $params) sku绑定物料标签
 * @method batchUpdateSkuSupplierByParams(array $params) 批量更新sku供应信息
 * @method updateSkuByParams(array $params) 更新sku 不发起审批
 * @method updateSkuSupplierAndApproveByParams(array $params) 更新sku供应信息
 * @method getSkuPageListByParams(array $params) sku分页列表
 * @method getSkuProductTagListByParams(array $params) sku摄影产品标签绑定信息
 * @method batchCreateSkuByParams(array $params) 批量创建sku信息
 * @method getSkuDetailByParams(array $params) sku详情
 * @method createSkuSupplierAndApproveByParams(array $params) 创建sku供应信息发起审批
 * @method updateSkuDemandGroupTagBindByParams(array $params) sku绑定需求方分组标签
 * @method updateSkuSupplierStatusByParams(array $params) 撤销供应商改价审批
 * @method getSkuIdsInnerSupplierIdsByParams(array $params) 通过 skuIds 获取供应商id交集 列表
 * @method getSkuSelectListByParams(array $params) sku筛选
 * @method delSkuSupplierDeleteByParams(array $params) 删除sku供应商
 * @method createSkuAndApproveByParams(array $params) 创建sku 创建审批
 * @method updateSkuAndApproveByParams(array $params) 更新sku 创建审批
 * @method batchCreateSkuSupplierByParams(array $params) 批量创建sku供应信息
 * @method revokeSkuStatusByParams(array $params) 撤回
 * @method batchUpdateSkuDemandGroupTagBindByParams(array $params) 批量sku绑定需求方分组标签
 * @method createSkuSupplierByParams(array $params) 创建sku供应信息不发起审批
 * @method updateStorePurchaseStatusByParams(array $params) 门店采购状态上下架
 * @method batchUpdateSkuSupplierPriceByParams(array $params) 批量更新sku供应商采购价
 * @method getMaterialTagListByParams(array $params) sku物料标签绑定信息
 * @method createSkuByParams(array $params) 创建sku 不创建审批
 * @method batchUpdateSkuByParams(array $params) 批量更新sku信息
 * @method deleteSkuByParams(array $params) sku删除
 * @method getEntrustSkuPageListByParams(array $params) sku协同采购物料分页列表
 * @method getSkuColorCodeListByParams(array $params) 查询物料款号
 * @method getSkuListAndCategoryByParams(array $params) sku列表包含分类搜索和展示
 * @method batchUpdateSkuMaterialTagBindByParams(array $params) 批量sku绑定物料标签
 * @method batchUpdateSkuSupplierDefaultByParams(array $params) 批量更新sku默认供应
 * @method updateSkuStockTypeByParams(array $params) 库存类型变更
 * @method updateHeadquartersPurchaseStatusByParams(array $params) 总部采购状态上下架
 * @method checkSkuColorCodeByParams(array $params) 校验物料款号
 * @method batchUpdateSkuProductTagBindByParams(array $params) 批量sku绑定摄影产品标签
 * @method getSkuSupplierListByParams(array $params) sku采购信息
 * @method updateSkuProductTagBindByParams(array $params) sku绑定摄影产品标签
 * @method getSkuDemandGroupListByParams(array $params) sku需求方分组绑定信息
 * @method updateSkuSupplierByParams(array $params) 更新sku供应信息
 * @method getMaterialSkuListByParams(array $params) sku列表
 */
class SkuController {
    private static string $serviceName = "BscSupplySaasMaterial";

    private static string $className = "SkuController";

    /**
     * sku列表
     * @return  array
    */
    public static function getSkuList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuListReq $skuListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuList($skuListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuListRes[]"
        );
    }

    /**
     * sku绑定物料标签
     * @return  bool
    */
    public static function updateSkuMaterialTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuMaterialTagBindUpdateReq $skuMaterialTagBindUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuMaterialTagBind($skuMaterialTagBindUpdateReq);
    }

    /**
     * 批量更新sku供应信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierBatchUpdateListReq $skuSupplierBatchUpdateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuSupplier($skuSupplierBatchUpdateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * 更新sku 不发起审批
     * @return  bool
    */
    public static function updateSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuUpdateReq $skuUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSku($skuUpdateReq);
    }

    /**
     * 更新sku供应信息
     * @return  bool
    */
    public static function updateSkuSupplierAndApprove (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierUpdateReq $skuSupplierUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuSupplierAndApprove($skuSupplierUpdateReq);
    }

    /**
     * sku分页列表
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes
    */
    public static function getSkuPageList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuPageListReq $skuPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuPageList($skuPageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes"
        );
    }

    /**
     * sku摄影产品标签绑定信息
     * @return  array
    */
    public static function getSkuProductTagList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\GetTageListReq $getTageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuProductTagList($getTageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuProductTagListRes[]"
        );
    }

    /**
     * 批量创建sku信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchCreateSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuBatchCreateListReq $skuBatchCreateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchCreateSku($skuBatchCreateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * sku详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuDetailRes
    */
    public static function getSkuDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuDetail([]),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuDetailRes"
        );
    }

    /**
     * 创建sku供应信息发起审批
     * @return  bool
    */
    public static function createSkuSupplierAndApprove (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierCreateReq $skuSupplierCreateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSkuSupplierAndApprove($skuSupplierCreateReq);
    }

    /**
     * sku绑定需求方分组标签
     * @return  bool
    */
    public static function updateSkuDemandGroupTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuDemandGroupTagBindUpdateReq $skuDemandGroupTagBindUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuDemandGroupTagBind($skuDemandGroupTagBindUpdateReq);
    }

    /**
     * 撤销供应商改价审批
     * @return  bool
    */
    public static function updateSkuSupplierStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierIdReq $skuSupplierIdReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuSupplierStatus($skuSupplierIdReq);
    }

    /**
     * 通过 skuIds 获取供应商id交集 列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuIdsInnerSupplierIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuIdsInnerSupplierIds([]);
    }

    /**
     * sku筛选
     * @return  array
    */
    public static function getSkuSelectList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSelectListReq $skuSelectListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuSelectList($skuSelectListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuSelectListRes[]"
        );
    }

    /**
     * 删除sku供应商
     * @return  bool
    */
    public static function delSkuSupplierDelete (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierIdReq $skuSupplierIdReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delSkuSupplierDelete($skuSupplierIdReq);
    }

    /**
     * 创建sku 创建审批
     * @return  bool
    */
    public static function createSkuAndApprove (\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuCreateReq $skuCreateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSkuAndApprove($skuCreateReq);
    }

    /**
     * 更新sku 创建审批
     * @return  bool
    */
    public static function updateSkuAndApprove (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuUpdateReq $skuUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuAndApprove($skuUpdateReq);
    }

    /**
     * 批量创建sku供应信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchCreateSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierBatchCreateListReq $skuSupplierBatchCreateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchCreateSkuSupplier($skuSupplierBatchCreateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * 撤回
     * @return  bool
    */
    public static function revokeSkuStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuRevokeUpdateReq $skuRevokeUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeSkuStatus($skuRevokeUpdateReq);
    }

    /**
     * 批量sku绑定需求方分组标签
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuDemandGroupTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuDemandGroupTagBindBatchUpdateReq $skuDemandGroupTagBindBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuDemandGroupTagBind($skuDemandGroupTagBindBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * 创建sku供应信息不发起审批
     * @return  bool
    */
    public static function createSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierCreateReq $skuSupplierCreateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSkuSupplier($skuSupplierCreateReq);
    }

    /**
     * 门店采购状态上下架
     * @return  bool
    */
    public static function updateStorePurchaseStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\UpdateStorePurchaseStatusReq $updateStorePurchaseStatusReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStorePurchaseStatus($updateStorePurchaseStatusReq);
    }

    /**
     * 批量更新sku供应商采购价
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuSupplierPrice (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierPriceListBatchUpdateReq $skuSupplierPriceListBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuSupplierPrice($skuSupplierPriceListBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * sku物料标签绑定信息
     * @return  array
    */
    public static function getMaterialTagList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\GetTageListReq $getTageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMaterialTagList($getTageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuMaterialTagRes[]"
        );
    }

    /**
     * 创建sku 不创建审批
     * @return  int
    */
    public static function createSku (\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuCreateReq $skuCreateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSku($skuCreateReq);
    }

    /**
     * 批量更新sku信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuBatchUpdateListReq $skuBatchUpdateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSku($skuBatchUpdateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * sku删除
     * @return  bool
    */
    public static function deleteSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuDeleteReq $skuDeleteReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSku($skuDeleteReq);
    }

    /**
     * sku协同采购物料分页列表
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes
    */
    public static function getEntrustSkuPageList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuPageListReq $skuPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getEntrustSkuPageList($skuPageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes"
        );
    }

    /**
     * 查询物料款号
     * @return  array
    */
    public static function getSkuColorCodeList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\MaterialSkuColorReq $materialSkuColorReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuColorCodeList($materialSkuColorReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\MaterialSkuColorRes[]"
        );
    }

    /**
     * sku列表包含分类搜索和展示
     * @return  array
    */
    public static function getSkuListAndCategory (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuListCategoryReq $skuListCategoryReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuListAndCategory($skuListCategoryReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuListRes[]"
        );
    }

    /**
     * 批量sku绑定物料标签
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuMaterialTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuMaterialTagBindBatchUpdateReq $skuMaterialTagBindBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuMaterialTagBind($skuMaterialTagBindBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * 批量更新sku默认供应
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuSupplierDefault (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierBatchUpdateDefaultListReq $skuSupplierBatchUpdateDefaultListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuSupplierDefault($skuSupplierBatchUpdateDefaultListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * 库存类型变更
     * @return  bool
    */
    public static function updateSkuStockType (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuUpdateStockTypeReq $skuUpdateStockTypeReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuStockType($skuUpdateStockTypeReq);
    }

    /**
     * 总部采购状态上下架
     * @return  bool
    */
    public static function updateHeadquartersPurchaseStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\UpdateHeadquartersPurchaseStatusReq $updateHeadquartersPurchaseStatusReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateHeadquartersPurchaseStatus($updateHeadquartersPurchaseStatusReq);
    }

    /**
     * 校验物料款号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\MaterialSkuColorBatchCheckRes
    */
    public static function checkSkuColorCode () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkSkuColorCode([]),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\MaterialSkuColorBatchCheckRes"
        );
    }

    /**
     * 批量sku绑定摄影产品标签
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuProductTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuProductTagBindBatchUpdateReq $skuProductTagBindBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuProductTagBind($skuProductTagBindBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }

    /**
     * sku采购信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuSupplierListRes
    */
    public static function getSkuSupplierList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuSupplierList([]),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuSupplierListRes"
        );
    }

    /**
     * sku绑定摄影产品标签
     * @return  bool
    */
    public static function updateSkuProductTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuProductTagBindUpdateReq $skuProductTagBindUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuProductTagBind($skuProductTagBindUpdateReq);
    }

    /**
     * sku需求方分组绑定信息
     * @return  array
    */
    public static function getSkuDemandGroupList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\GetTageListReq $getTageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuDemandGroupList($getTageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuDemandGroupRes[]"
        );
    }

    /**
     * 更新sku供应信息
     * @return  bool
    */
    public static function updateSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierUpdateReq $skuSupplierUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuSupplier($skuSupplierUpdateReq);
    }

    /**
     * sku列表
     * @return  array
    */
    public static function getMaterialSkuList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuListReq $skuListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuList($skuListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuListRes[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}