<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-11 14:47:58
 */
namespace Mainto\Bridge\Invokes\BscSupplySaasMaterial;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SkuController
 */
class SkuController {
    private static string $serviceName = "BscSupplySaasMaterial";

    private static string $className = "SkuController";

    /**
     * sku列表
     * @return  array
    */
    public static function getSkuList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuListReq $skuListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuList($skuListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuListRes[]"
        );
    }
    /**
     * sku绑定物料标签
     * @return  bool
    */
    public static function updateSkuMaterialTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuMaterialTagBindUpdateReq $skuMaterialTagBindUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuMaterialTagBind($skuMaterialTagBindUpdateReq);
    }
    /**
     * 批量更新sku供应信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierBatchUpdateListReq $skuSupplierBatchUpdateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuSupplier($skuSupplierBatchUpdateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * 更新sku 不发起审批
     * @return  bool
    */
    public static function updateSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuUpdateReq $skuUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSku($skuUpdateReq);
    }
    /**
     * skusku分页列表
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes
    */
    public static function getSkuPageList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuPageListReq $skuPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuPageList($skuPageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes"
        );
    }
    /**
     * 更新sku供应信息
     * @return  bool
    */
    public static function updateSkuSupplierAndApprove (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierUpdateReq $skuSupplierUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuSupplierAndApprove($skuSupplierUpdateReq);
    }
    /**
     * sku摄影产品标签绑定信息
     * @return  array
    */
    public static function getSkuProductTagList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\GetTageListReq $getTageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuProductTagList($getTageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuProductTagListRes[]"
        );
    }
    /**
     * 批量新增sku信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchCreateSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuBatchUpdateListReq $skuBatchUpdateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchCreateSku($skuBatchUpdateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * sku详情
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuDetailRes
    */
    public static function getSkuDetail (int $skuId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuDetail(["skuId" => $skuId]),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuDetailRes"
        );
    }
    /**
     * 创建sku供应信息发起审批
     * @return  bool
    */
    public static function createSkuSupplierAndApprove (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierCreateReq $skuSupplierCreateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSkuSupplierAndApprove($skuSupplierCreateReq);
    }
    /**
     * sku绑定需求方分组标签
     * @return  bool
    */
    public static function updateSkuDemandGroupTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuDemandGroupTagBindUpdateReq $skuDemandGroupTagBindUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuDemandGroupTagBind($skuDemandGroupTagBindUpdateReq);
    }
    /**
     * 撤销供应商改价审批
     * @return  bool
    */
    public static function updateSkuSupplierStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierIdReq $skuSupplierIdReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuSupplierStatus($skuSupplierIdReq);
    }
    /**
     * sku筛选
     * @return  array
    */
    public static function getSkuSelectList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSelectListReq $skuSelectListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuSelectList($skuSelectListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuSelectListRes[]"
        );
    }
    /**
     * 删除sku供应商
     * @return  bool
    */
    public static function delSkuSupplierDelete (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierIdReq $skuSupplierIdReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delSkuSupplierDelete($skuSupplierIdReq);
    }
    /**
     * 创建sku 创建审批
     * @return  bool
    */
    public static function createSkuAndApprove (\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuCreateReq $skuCreateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSkuAndApprove($skuCreateReq);
    }
    /**
     * 更新sku 创建审批
     * @return  bool
    */
    public static function updateSkuAndApprove (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuUpdateReq $skuUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuAndApprove($skuUpdateReq);
    }
    /**
     * 批量创建sku供应信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchCreateSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierBatchCreateListReq $skuSupplierBatchCreateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchCreateSkuSupplier($skuSupplierBatchCreateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * 批量sku绑定需求方分组标签
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuDemandGroupTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuDemandGroupTagBindBatchUpdateReq $skuDemandGroupTagBindBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuDemandGroupTagBind($skuDemandGroupTagBindBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * 撤回
     * @return  bool
    */
    public static function revokeSkuStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuRevokeUpdateReq $skuRevokeUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeSkuStatus($skuRevokeUpdateReq);
    }
    /**
     * 门店采购状态上下架
     * @return  bool
    */
    public static function updateStorePurchaseStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\UpdateStorePurchaseStatusReq $updateStorePurchaseStatusReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStorePurchaseStatus($updateStorePurchaseStatusReq);
    }
    /**
     * 创建sku供应信息不发起审批
     * @return  bool
    */
    public static function createSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierCreateReq $skuSupplierCreateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSkuSupplier($skuSupplierCreateReq);
    }
    /**
     * 批量更新sku供应商采购价
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuSupplierPrice (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierPriceListBatchUpdateReq $skuSupplierPriceListBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuSupplierPrice($skuSupplierPriceListBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * sku物料标签绑定信息
     * @return  array
    */
    public static function getMaterialTagList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\GetTageListReq $getTageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMaterialTagList($getTageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuMaterialTagRes[]"
        );
    }
    /**
     * 创建sku 不创建审批
     * @return  int
    */
    public static function createSku (\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuCreateReq $skuCreateReq) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSku($skuCreateReq);
    }
    /**
     * 批量更新sku信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuBatchUpdateListReq $skuBatchUpdateListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSku($skuBatchUpdateListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * sku协同采购物料分页列表
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes
    */
    public static function getEntrustSkuPageList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuPageListReq $skuPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getEntrustSkuPageList($skuPageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuPageListRes"
        );
    }
    /**
     * sku删除
     * @return  bool
    */
    public static function deleteSku (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuDeleteReq $skuDeleteReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSku($skuDeleteReq);
    }
    /**
     * 批量sku绑定物料标签
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuMaterialTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuMaterialTagBindBatchUpdateReq $skuMaterialTagBindBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuMaterialTagBind($skuMaterialTagBindBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * 查询物料款号
     * @return  array
    */
    public static function getSkuColorCodeList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\MaterialSkuColorReq $materialSkuColorReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuColorCodeList($materialSkuColorReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\MaterialSkuColorRes[]"
        );
    }
    /**
     * 总部采购状态上下架
     * @return  bool
    */
    public static function updateHeadquartersPurchaseStatus (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\UpdateHeadquartersPurchaseStatusReq $updateHeadquartersPurchaseStatusReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateHeadquartersPurchaseStatus($updateHeadquartersPurchaseStatusReq);
    }
    /**
     * 库存类型变更
     * @return  bool
    */
    public static function updateSkuStockType (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuUpdateStockTypeReq $skuUpdateStockTypeReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuStockType($skuUpdateStockTypeReq);
    }
    /**
     * 校验物料款号
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\MaterialSkuColorBatchCheckRes
    */
    public static function checkSkuColorCode (array $codeList) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkSkuColorCode(["codeList" => $codeList]),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\MaterialSkuColorBatchCheckRes"
        );
    }
    /**
     * 批量sku绑定摄影产品标签
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes
    */
    public static function batchUpdateSkuProductTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuProductTagBindBatchUpdateReq $skuProductTagBindBatchUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuProductTagBind($skuProductTagBindBatchUpdateReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\BatchExportRes"
        );
    }
    /**
     * sku绑定摄影产品标签
     * @return  bool
    */
    public static function updateSkuProductTagBind (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuProductTagBindUpdateReq $skuProductTagBindUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuProductTagBind($skuProductTagBindUpdateReq);
    }
    /**
     * sku采购信息
     * @return  \Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuSupplierListRes
    */
    public static function getSkuSupplierList (int $skuId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuSupplierList(["skuId" => $skuId]),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuSupplierListRes"
        );
    }
    /**
     * sku需求方分组绑定信息
     * @return  array
    */
    public static function getSkuDemandGroupList (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\GetTageListReq $getTageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuDemandGroupList($getTageListReq),
            "\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Res\SkuDemandGroupRes[]"
        );
    }
    /**
     * 更新sku供应信息
     * @return  bool
    */
    public static function updateSkuSupplier (?\Mainto\Bridge\Structs\BscSupplySaasMaterial\Com\Mainto\Supply\Material\Model\Req\SkuSupplierUpdateReq $skuSupplierUpdateReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSkuSupplier($skuSupplierUpdateReq);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}