<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-22 14:32:43
 */
namespace Mainto\Bridge\Invokes\BscFinance;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class IBillAccountService
 * @method getBillAccountNameByBillChannelIdByParams(array $params) 账号-根据渠道获取账户名称
 * @method corporationPageListByParams(array $params) 账号-组织列表-分页
 * @method corporationListByParams(array $params) 账号-组织列表-不分页
 * @method getBillTypeListAndBillAccountListByBillChannelIdByParams(array $params) 账号-根据渠道获取账单类型和账单账号
 * @method queryBillChannelListByParams(array $params) 账号-账单渠道列表
 * @method queryBillAccountDetailByIdByParams(array $params) 账号-账号详情
 * @method getBillMerchantNoByBillChannelIdByParams(array $params) 账号-根据渠道获取账户商户号
 * @method updateBillAccountByParams(array $params) 账号-修改账号
 * @method createBillAccountByParams(array $params) 账号-创建账号
 * @method pageQueryBillAccountByParams(array $params) 账号-账号列表
 */
class IBillAccountService {
    private static string $serviceName = "BscFinance";

    private static string $className = "IBillAccountService";

    /**
     * 账号-根据渠道获取账户名称
     * @return  array
    */
    public static function getBillAccountNameByBillChannelId () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBillAccountNameByBillChannelId([]),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillAccountDetailFrontDTO[]"
        );
    }
    /**
     * 账号-组织列表-分页
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\CorporationPageListFrontDTO
    */
    public static function corporationPageList (?\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Request\BillCenter\PageQueryCorporationFrontRequest $pageQueryCorporationFrontRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->corporationPageList($pageQueryCorporationFrontRequest),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\CorporationPageListFrontDTO"
        );
    }
    /**
     * 账号-组织列表-不分页
     * @return  array
    */
    public static function corporationList (?\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Request\BillCenter\QueryCorporationFrontRequest $queryCorporationFrontRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->corporationList($queryCorporationFrontRequest),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\CorporationFrontDTO[]"
        );
    }
    /**
     * 账号-根据渠道获取账单类型和账单账号
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillChannelWithBillTypeAndBillAccountFrontDTO
    */
    public static function getBillTypeListAndBillAccountListByBillChannelId () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBillTypeListAndBillAccountListByBillChannelId([]),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillChannelWithBillTypeAndBillAccountFrontDTO"
        );
    }
    /**
     * 账号-账单渠道列表
     * @return  array
    */
    public static function queryBillChannelList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillChannelList(),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillChannelFrontDTO[]"
        );
    }
    /**
     * 账号-账号详情
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillAccountDetailFrontDTO
    */
    public static function queryBillAccountDetailById () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->queryBillAccountDetailById([]),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillAccountDetailFrontDTO"
        );
    }
    /**
     * 账号-根据渠道获取账户商户号
     * @return  array
    */
    public static function getBillMerchantNoByBillChannelId () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBillMerchantNoByBillChannelId([]),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillAccountDetailFrontDTO[]"
        );
    }
    /**
     * 账号-修改账号
     * @return  bool
    */
    public static function updateBillAccount (?\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Request\BillCenter\UpdateBillAccountFrontRequest $updateBillAccountFrontRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateBillAccount($updateBillAccountFrontRequest);
    }
    /**
     * 账号-创建账号
     * @return  bool
    */
    public static function createBillAccount (?\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Request\BillCenter\CreateBillAccountFrontRequest $createBillAccountFrontRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createBillAccount($createBillAccountFrontRequest);
    }
    /**
     * 账号-账号列表
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillAccountListPageFrontDTO
    */
    public static function pageQueryBillAccount (?\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Request\BillCenter\PageQueryBillAccountFrontRequest $pageQueryBillAccountFrontRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->pageQueryBillAccount($pageQueryBillAccountFrontRequest),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillAccountListPageFrontDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}