<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-22 13:54:39
 */
namespace Mainto\Bridge\Invokes\BscFinance;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class IBillUploadRecordService
 * @method downloadBillFileByParams(array $params) 账单文件下载
 * @method pageQueryBillBillUploadRecordByParams(array $params) 账单上传记录列表查询-分页
 * @method getBillUploadQueryParamsByParams(array $params) 账单上传记录列表-查询条件获取
 * @method getQiniuTokenByParams(array $params) 七牛-获取token
 * @method abolishBillUploadRecordByParams(array $params) 账单作废
 * @method billUploadByParams(array $params) 账单上传
 */
class IBillUploadRecordService {
    private static string $serviceName = "BscFinance";

    private static string $className = "IBillUploadRecordService";

    /**
     * 账单文件下载
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\QiniuDownloadDTO
    */
    public static function downloadBillFile () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->downloadBillFile([]),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\QiniuDownloadDTO"
        );
    }
    /**
     * 账单上传记录列表查询-分页
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillUploadRecordPageFrontDTO
    */
    public static function pageQueryBillBillUploadRecord (?\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Request\BillCenter\PageQueryBillUploadRecordFrontRequest $pageQueryBillUploadRecordFrontRequest = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->pageQueryBillBillUploadRecord($pageQueryBillUploadRecordFrontRequest),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillUploadRecordPageFrontDTO"
        );
    }
    /**
     * 账单上传记录列表-查询条件获取
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillUploadRecordQueryParamsFrontDTO
    */
    public static function getBillUploadQueryParams () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBillUploadQueryParams(),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\BillUploadRecordQueryParamsFrontDTO"
        );
    }
    /**
     * 七牛-获取token
     * @return  \Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\QiniuTokenDTO
    */
    public static function getQiniuToken () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getQiniuToken(),
            "\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Response\BillCenter\QiniuTokenDTO"
        );
    }
    /**
     * 账单作废
     * @return  bool
    */
    public static function abolishBillUploadRecord () {
        return RpcClass::getClass(self::$serviceName, self::$className)->abolishBillUploadRecord([]);
    }
    /**
     * 账单上传
     * @return  bool
    */
    public static function billUpload (?\Mainto\Bridge\Structs\BscFinance\Com\Mainto\Earthen\Finance\Application\Api\Request\BillCenter\CreateBillUploadRecordFrontRequest $createBillUploadRecordFrontRequest = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->billUpload($createBillUploadRecordFrontRequest);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}