<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-27 16:38:34
 */
namespace Mainto\Bridge\Invokes\BscFinanceCost;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ManageSite
 * @method splitDetailByParams(array $params) 场地费用和折旧费用分摊明细
 * @method doTestByParams(array $params) 测试
 * @method getDepreciationByParams(array $params) 从金蝶折旧调整单获取数据
 * @method getSiteAmountByParams(array $params) 从租金系统数据（固定租金，物业管理费，商场推广费）需要剔税
 * @method saveNonOperatingByParams(array $params) 场地费用和折旧费用计算非经
 * @method fixedSiteSummaryByParams(array $params) 租金系统数据（固定租金，物业管理费，商场推广费）摊前汇总
 * @method fixedAssetSummaryByParams(array $params) 金蝶折旧调整单数据摊前汇总
 */
class ManageSite {
    private static string $serviceName = "BscFinanceCost";

    private static string $className = "ManageSite";

    /**
     * 场地费用和折旧费用分摊明细
     * @return  bool
    */
    public static function splitDetail (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Manage\Biz\Params\TaskDataParam $taskDataParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->splitDetail($taskDataParam);
    }

    /**
     * 测试
     * @return  bool
    */
    public static function doTest (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Manage\Biz\Params\TaskDataParam $taskDataParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doTest($taskDataParam);
    }

    /**
     * 从金蝶折旧调整单获取数据
     * @return  bool
    */
    public static function getDepreciation (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Manage\Biz\Params\TaskDataParam $taskDataParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepreciation($taskDataParam);
    }

    /**
     * 从租金系统数据（固定租金，物业管理费，商场推广费）需要剔税
     * @return  bool
    */
    public static function getSiteAmount (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Manage\Biz\Params\TaskDataParam $taskDataParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSiteAmount($taskDataParam);
    }

    /**
     * 场地费用和折旧费用计算非经
     * @return  bool
    */
    public static function saveNonOperating (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Manage\Biz\Params\TaskDataParam $taskDataParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveNonOperating($taskDataParam);
    }

    /**
     * 租金系统数据（固定租金，物业管理费，商场推广费）摊前汇总
     * @return  bool
    */
    public static function fixedSiteSummary (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Manage\Biz\Params\TaskDataParam $taskDataParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixedSiteSummary($taskDataParam);
    }

    /**
     * 金蝶折旧调整单数据摊前汇总
     * @return  bool
    */
    public static function fixedAssetSummary (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Manage\Biz\Params\TaskDataParam $taskDataParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixedAssetSummary($taskDataParam);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}