<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-07 16:36:06
 */
namespace Mainto\Bridge\Invokes\BscFinanceCost;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CostIdle
 * @method doCalcByParams(array $params) 简化计算步骤
 * @method autoProcessTaskByParams(array $params) 自动顺序执行月度成本分配任务
 * @method saveCostNonOperatingByParams(array $params) 计算非经成本
 * @method processTaskByParams(array $params) 单一执行月度成本分配任务
 * @method saveCostSplitSummaryByParams(array $params) 按分类和部门进行汇总
 * @method taskListByParams(array $params) 月度任务列表
 * @method initCostSpiltDetailByParams(array $params) 初写费用成本分摊明细表
 * @method saveCostIdleByParams(array $params) 计算闲置成本
 * @method saveIncompleteMonthByParams(array $params) 月度半成品转结
 * @method unlockTaskByParams(array $params) 解锁任务
 * @method getDepartmentOccupyRecordByParams(array $params) 获取占点数据
 * @method saveCostSummaryByParams(array $params) 从费用明细生成费用汇总
 * @method saveCostPrepareSummaryByParams(array $params) 计算摊前汇总
 * @method retryProcessTaskByParams(array $params) 重新执行月度成本分配任务
 * @method saveCostSplitMonthByParams(array $params) 汇总月度半成品和成品
 * @method lockTaskByParams(array $params) 锁定任务
 * @method saveCostSplitDetailByParams(array $params) 计算成本分摊明细表
 * @method saveKingdeeCostListByParams(array $params) 从金蝶获取成本费用数据并保存
 * @method initMonthSplitTaskByParams(array $params) 初始化月度分配任务
 */
class CostIdle {
    private static string $serviceName = "BscFinanceCost";

    private static string $className = "CostIdle";

    /**
     * 简化计算步骤
     * @return  bool
    */
    public static function doCalc (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->doCalc($costAllocationParam);
    }

    /**
     * 自动顺序执行月度成本分配任务
     * @return  bool
    */
    public static function autoProcessTask (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoProcessTask($costAllocationParam);
    }

    /**
     * 计算非经成本
     * @return  bool
    */
    public static function saveCostNonOperating (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCostNonOperating($costAllocationParam);
    }

    /**
     * 单一执行月度成本分配任务
     * @return  bool
    */
    public static function processTask (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\MonthTaskParam $monthTaskParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->processTask($monthTaskParam);
    }

    /**
     * 按分类和部门进行汇总
     * @return  bool
    */
    public static function saveCostSplitSummary (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCostSplitSummary($costAllocationParam);
    }

    /**
     * 月度任务列表
     * @return  \Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Res\TaskListDTO
    */
    public static function taskList (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->taskList($costAllocationParam),
            "\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Res\TaskListDTO"
        );
    }

    /**
     * 初写费用成本分摊明细表
     * @return  bool
    */
    public static function initCostSpiltDetail (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\InitCostAllocationParam $initCostAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->initCostSpiltDetail($initCostAllocationParam);
    }

    /**
     * 计算闲置成本
     * @return  bool
    */
    public static function saveCostIdle (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCostIdle($costAllocationParam);
    }

    /**
     * 月度半成品转结
     * @return  bool
    */
    public static function saveIncompleteMonth (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveIncompleteMonth($costAllocationParam);
    }

    /**
     * 解锁任务
     * @return  bool
    */
    public static function unlockTask (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unlockTask($costAllocationParam);
    }

    /**
     * 获取占点数据
     * @return  bool
    */
    public static function getDepartmentOccupyRecord (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentOccupyRecord($costAllocationParam);
    }

    /**
     * 从费用明细生成费用汇总
     * @return  bool
    */
    public static function saveCostSummary (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCostSummary($costAllocationParam);
    }

    /**
     * 计算摊前汇总
     * @return  bool
    */
    public static function saveCostPrepareSummary (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCostPrepareSummary($costAllocationParam);
    }

    /**
     * 重新执行月度成本分配任务
     * @return  bool
    */
    public static function retryProcessTask (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\RetryCostAllocationParam $retryCostAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retryProcessTask($retryCostAllocationParam);
    }

    /**
     * 汇总月度半成品和成品
     * @return  bool
    */
    public static function saveCostSplitMonth (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCostSplitMonth($costAllocationParam);
    }

    /**
     * 锁定任务
     * @return  bool
    */
    public static function lockTask (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lockTask($costAllocationParam);
    }

    /**
     * 计算成本分摊明细表
     * @return  bool
    */
    public static function saveCostSplitDetail (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveCostSplitDetail($costAllocationParam);
    }

    /**
     * 从金蝶获取成本费用数据并保存
     * @return  bool
    */
    public static function saveKingdeeCostList (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveKingdeeCostList($costAllocationParam);
    }

    /**
     * 初始化月度分配任务
     * @return  bool
    */
    public static function initMonthSplitTask (?\Mainto\Bridge\Structs\BscFinanceCost\Com\Mainto\Finance\Cost\Allocation\Biz\Params\CostAllocationParam $costAllocationParam = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->initMonthSplitTask($costAllocationParam);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}